/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.service.ReprocessingService;

public class ReprocessingOneMailTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"reprocessing-one");
    private final ReprocessingService reprocessingService;
    private final MailRepositoryPath repositoryPath;
    private final MailQueueName targetQueue;
    private final MailKey mailKey;
    private final Optional<String> targetProcessor;
    private final AdditionalInformation additionalInformation;

    public ReprocessingOneMailTask(ReprocessingService reprocessingService, MailRepositoryPath repositoryPath, MailQueueName targetQueue, MailKey mailKey, Optional<String> targetProcessor, Clock clock) {
        this.reprocessingService = reprocessingService;
        this.repositoryPath = repositoryPath;
        this.targetQueue = targetQueue;
        this.mailKey = mailKey;
        this.targetProcessor = targetProcessor;
        this.additionalInformation = new AdditionalInformation(repositoryPath, targetQueue, mailKey, targetProcessor, clock.instant());
    }

    public Task.Result run() {
        try {
            this.reprocessingService.reprocess(this.repositoryPath, this.mailKey, this.targetProcessor, this.targetQueue);
            return Task.Result.COMPLETED;
        }
        catch (MessagingException | MailRepositoryStore.MailRepositoryStoreException e) {
            LOGGER.error("Encountered error while reprocessing repository", e);
            return Task.Result.PARTIAL;
        }
    }

    public TaskType type() {
        return TYPE;
    }

    MailRepositoryPath getRepositoryPath() {
        return this.repositoryPath;
    }

    MailQueueName getTargetQueue() {
        return this.targetQueue;
    }

    MailKey getMailKey() {
        return this.mailKey;
    }

    Optional<String> getTargetProcessor() {
        return this.targetProcessor;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.additionalInformation);
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailRepositoryPath repositoryPath;
        private final String targetQueue;
        private final MailKey mailKey;
        private final Optional<String> targetProcessor;
        private final Instant timestamp;

        public AdditionalInformation(MailRepositoryPath repositoryPath, MailQueueName targetQueue, MailKey mailKey, Optional<String> targetProcessor, Instant timestamp) {
            this.repositoryPath = repositoryPath;
            this.targetQueue = targetQueue.asString();
            this.mailKey = mailKey;
            this.targetProcessor = targetProcessor;
            this.timestamp = timestamp;
        }

        public String getMailKey() {
            return this.mailKey.asString();
        }

        public String getTargetQueue() {
            return this.targetQueue;
        }

        public Optional<String> getTargetProcessor() {
            return this.targetProcessor;
        }

        public String getRepositoryPath() {
            return this.repositoryPath.asString();
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    public static class InvalidMailRepositoryPathDeserializationException
    extends RuntimeException {
        public InvalidMailRepositoryPathDeserializationException(String mailRepositoryPath) {
            super("Unable to deserialize: '" + mailRepositoryPath + "' can not be url decoded");
        }
    }

    public static class UrlEncodingFailureSerializationException
    extends RuntimeException {
        public UrlEncodingFailureSerializationException(MailRepositoryPath mailRepositoryPath) {
            super("Unable to serialize: '" + mailRepositoryPath.asString() + "' can not be url encoded");
        }
    }
}

