/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import com.google.common.collect.ImmutableList;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.james.protocols.api.ProtocolServer;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.util.ExternalResourceReleasable;

public abstract class AbstractAsyncServer
implements ProtocolServer {
    public static final int DEFAULT_IO_WORKER_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private volatile int backlog = 250;
    private volatile int timeout = 120;
    private ServerBootstrap bootstrap;
    private volatile boolean started;
    private final ChannelGroup channels = new DefaultChannelGroup();
    private volatile int ioWorker = DEFAULT_IO_WORKER_COUNT;
    private List<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();

    public synchronized void setListenAddresses(InetSocketAddress ... addresses) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.addresses = ImmutableList.copyOf((Object[])addresses);
    }

    public void setIoWorkerCount(int ioWorker) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.ioWorker = ioWorker;
    }

    public synchronized void bind() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Server running already");
        }
        if (this.addresses.isEmpty()) {
            throw new RuntimeException("Please specify at least on socketaddress to which the server should get bound!");
        }
        this.bootstrap = new ServerBootstrap((ChannelFactory)this.createSocketChannelFactory());
        ChannelPipelineFactory factory = this.createPipelineFactory(this.channels);
        this.bootstrap.setPipelineFactory(factory);
        this.configureBootstrap(this.bootstrap);
        for (InetSocketAddress address : this.addresses) {
            this.channels.add((Object)this.bootstrap.bind((SocketAddress)address));
        }
        this.started = true;
    }

    protected void configureBootstrap(ServerBootstrap bootstrap) {
        bootstrap.setOption("backlog", (Object)this.backlog);
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
    }

    protected ServerSocketChannelFactory createSocketChannelFactory() {
        return new NioServerSocketChannelFactory(this.createBossExecutor(), this.createWorkerExecutor(), this.ioWorker);
    }

    public synchronized void unbind() {
        if (!this.started) {
            return;
        }
        ChannelPipelineFactory factory = this.bootstrap.getPipelineFactory();
        if (factory instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)factory).releaseExternalResources();
        }
        this.channels.close().awaitUninterruptibly();
        this.bootstrap.releaseExternalResources();
        this.started = false;
    }

    public synchronized List<InetSocketAddress> getListenAddresses() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Channel channel : ImmutableList.copyOf((Iterator)this.channels.iterator())) {
            builder.add((Object)((InetSocketAddress)channel.getLocalAddress()));
        }
        return builder.build();
    }

    protected List<InetSocketAddress> getListenAddressesBeforeBind() {
        return Collections.unmodifiableList(this.addresses);
    }

    protected abstract ChannelPipelineFactory createPipelineFactory(ChannelGroup var1);

    public void setTimeout(int timeout) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.timeout = timeout;
    }

    public void setBacklog(int backlog) {
        if (this.started) {
            throw new IllegalStateException("Can only be set when the server is not running");
        }
        this.backlog = backlog;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected Executor createBossExecutor() {
        NamedThreadFactory threadFactory = NamedThreadFactory.withClassName(this.getClass());
        return Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }

    protected Executor createWorkerExecutor() {
        NamedThreadFactory threadFactory = NamedThreadFactory.withClassName(this.getClass());
        return Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }

    public boolean isBound() {
        return this.started;
    }
}

