/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.core.lifecycle;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.savignano.uptrust.config.core.lifecycle.StartupLogMonitor;
import net.savignano.uptrust.config.infrastructure.logging.LogEntry;
import net.savignano.uptrust.config.infrastructure.logging.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StartupLogMonitor {
    private static final Logger logger = LoggerFactory.getLogger(StartupLogMonitor.class);
    private final LogService logService;

    public StartupLogMonitor(LogService logService) {
        this.logService = logService;
    }

    public List<String> getErrorLogsSince(LocalDateTime startTime) {
        logger.debug("Checking for error logs since: {}", (Object)startTime);
        try {
            List errorEntries = this.logService.getErrorLogsAfterTimestamp(startTime);
            List<String> errorLogs = errorEntries.stream().map(LogEntry::getMessage).collect(Collectors.toList());
            if (!errorLogs.isEmpty()) {
                logger.info("Found {} error log(s) during startup", (Object)errorLogs.size());
            }
            return errorLogs;
        }
        catch (Exception e) {
            logger.warn("Failed to check for startup error logs", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public List<String> getWarningLogsSince(LocalDateTime startTime) {
        logger.debug("Checking for warning logs since: {}", (Object)startTime);
        try {
            List warningEntries = this.logService.getWarningLogsAfterTimestamp(startTime);
            List<String> warningLogs = warningEntries.stream().map(LogEntry::getMessage).collect(Collectors.toList());
            if (!warningLogs.isEmpty()) {
                logger.info("Found {} warning log(s) during startup", (Object)warningLogs.size());
            }
            return warningLogs;
        }
        catch (Exception e) {
            logger.warn("Failed to check for startup warning logs", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartupLogResult captureLogsDuring(Runnable operation) {
        LocalDateTime startTime = LocalDateTime.now();
        try {
            operation.run();
        }
        finally {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        List errorLogs = this.getErrorLogsSince(startTime);
        List warningLogs = this.getWarningLogsSince(startTime);
        return new StartupLogResult(errorLogs, warningLogs);
    }
}

