/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.core.lifecycle;

import java.io.IOException;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerStatus;
import net.savignano.uptrust.config.core.lifecycle.process.ProcessManager;
import net.savignano.uptrust.config.core.lifecycle.process.ProcessMonitorService;
import net.savignano.uptrust.config.core.lifecycle.status.ServerStatusResolver;
import net.savignano.uptrust.config.infrastructure.storage.FileCleanupService;
import net.savignano.uptrust.config.shared.exception.UptrustServerStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UptrustServerService {
    private static final Logger logger = LoggerFactory.getLogger(UptrustServerService.class);
    private final ProcessManager processManager;
    private final ProcessMonitorService processMonitorService;
    private final ServerStatusResolver statusResolver;
    private final FileCleanupService fileCleanupService;

    public UptrustServerService(ProcessManager processManager, ProcessMonitorService processMonitorService, ServerStatusResolver statusResolver, FileCleanupService fileCleanupService) {
        this.processManager = processManager;
        this.processMonitorService = processMonitorService;
        this.statusResolver = statusResolver;
        this.fileCleanupService = fileCleanupService;
    }

    public UptrustServerStatus startServer() throws IOException {
        logger.info("Starting Uptrust server...");
        this.statusResolver.validateNoOtherServerRunning();
        Process process = this.processManager.startProcess();
        this.processMonitorService.startMonitoring(process);
        return this.handleServerStartup();
    }

    public UptrustServerStatus restartServer() throws IOException {
        logger.info("Restarting Uptrust server...");
        this.stopServer();
        Process process = this.processManager.startProcess();
        this.processMonitorService.startMonitoring(process);
        return this.handleServerStartup();
    }

    public void stopServer() {
        logger.info("Stopping Uptrust server...");
        this.processMonitorService.stopMonitoring();
        this.processManager.stopProcess();
    }

    public UptrustServerStatus getServerStatus() {
        return this.statusResolver.getCurrentStatus();
    }

    public UptrustServerStatus waitForServerReady() {
        return this.statusResolver.waitForServerReady();
    }

    public UptrustServerStatus waitForServerReady(long timeoutMillis, long pollInterval) {
        return this.statusResolver.waitForServerReady(timeoutMillis, pollInterval);
    }

    public boolean isServerRunning() {
        return this.processManager.isProcessRunning();
    }

    private UptrustServerStatus handleServerStartup() throws UptrustServerStatusException {
        UptrustServerStatus status = this.statusResolver.waitForServerReady();
        if (status != UptrustServerStatus.RUNNING) {
            logger.error("Uptrust server failed to start properly. Status: {}", (Object)status);
            this.stopServer();
            throw new UptrustServerStatusException(status);
        }
        logger.info("Uptrust server started successfully, performing file cleanup...");
        this.fileCleanupService.cleanupAfterSuccessfulRestart();
        return status;
    }
}

