/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.core.lifecycle.health;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import net.savignano.uptrust.config.core.lifecycle.health.HealthCheckResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckClient {
    private static final Logger logger = LoggerFactory.getLogger(HealthCheckClient.class);
    private final String healthCheckUrl;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private static final String ENCODED_ENDPOINT = "/checks/Guice%20application%20lifecycle";

    public HealthCheckClient(@Value(value="${james.healthcheck.url}") String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl + ENCODED_ENDPOINT;
        this.objectMapper = new ObjectMapper();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    public boolean isHealthy() throws Exception {
        logger.debug("Performing health check on Uptrust server at {}", (Object)this.healthCheckUrl);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.healthCheckUrl)).timeout(Duration.ofSeconds(5L)).build();
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                logger.warn("Health check failed with status code: {}", (Object)response.statusCode());
                return false;
            }
            HealthCheckResponse healthCheck = (HealthCheckResponse)this.objectMapper.readValue(response.body(), HealthCheckResponse.class);
            boolean isHealthy = "healthy".equals(healthCheck.status());
            if (!isHealthy) {
                logger.warn("Health check response indicated unhealthy status: {}", (Object)healthCheck.status());
            }
            return isHealthy;
        }
        catch (Exception e) {
            logger.debug("Health check request failed", (Throwable)e);
            throw e;
        }
    }
}

