/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.core.lifecycle.process;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ProcessManager {
    private static final Logger logger = LoggerFactory.getLogger(ProcessManager.class);
    private Process serverProcess;
    private final String serverJarPath;
    private final String passwordEncryptionKey;

    public ProcessManager(@Value(value="${uptrust.gateway.path}") String serverJarPath, @Value(value="${password.encryption.key:}") String passwordEncryptionKey) {
        this.serverJarPath = serverJarPath;
        this.passwordEncryptionKey = passwordEncryptionKey;
    }

    public synchronized Process startProcess() throws IOException {
        if (this.isProcessRunning()) {
            throw new IllegalStateException("Server process is already running");
        }
        Path resolvedJarPath = Paths.get(this.serverJarPath, new String[0]).toAbsolutePath();
        Path jarDirectory = resolvedJarPath.getParent();
        logger.info("Starting Uptrust server process with JAR: {}", (Object)resolvedJarPath);
        if (!Files.exists(resolvedJarPath, new LinkOption[0])) {
            throw new IOException("Server JAR file does not exist: " + String.valueOf(resolvedJarPath));
        }
        ProcessBuilder processBuilder = this.createProcessBuilder(resolvedJarPath, jarDirectory);
        this.serverProcess = processBuilder.start();
        logger.debug("Server process started with PID: {}", (Object)this.serverProcess.pid());
        return this.serverProcess;
    }

    public synchronized void stopProcess() {
        if (this.isProcessRunning()) {
            logger.info("Stopping Uptrust server process");
            this.serverProcess.destroyForcibly();
            try {
                this.serverProcess.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Interrupted while waiting for process termination");
            }
            this.serverProcess = null;
        }
    }

    public synchronized boolean isProcessRunning() {
        return this.serverProcess != null && this.serverProcess.isAlive();
    }

    public synchronized Process getProcess() {
        return this.isProcessRunning() ? this.serverProcess : null;
    }

    private ProcessBuilder createProcessBuilder(Path jarPath, Path workingDirectory) {
        ProcessBuilder pb = new ProcessBuilder("java", "-Dworking.directory=.", "-Dlogback.configurationFile=conf/logback.xml", "-Dpassword.encryption.key=" + this.passwordEncryptionKey, "-jar", jarPath.toString());
        pb.directory(workingDirectory.toFile());
        pb.redirectErrorStream(true);
        return pb;
    }
}

