/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.core.lifecycle.process;

import jakarta.annotation.PreDestroy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.savignano.uptrust.config.core.lifecycle.config.LifecycleConfiguration;
import net.savignano.uptrust.config.infrastructure.logging.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProcessMonitorService {
    private static final Logger logger = LoggerFactory.getLogger(ProcessMonitorService.class);
    private final LogService logService;
    private final LifecycleConfiguration config;
    private final ExecutorService executorService;
    private CompletableFuture<Void> outputMonitorFuture;
    private CompletableFuture<Integer> processMonitorFuture;

    public ProcessMonitorService(LogService logService, LifecycleConfiguration config) {
        this.logService = logService;
        this.config = config;
        this.executorService = Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("uptrust-monitor-" + t.getId());
            return t;
        });
    }

    public void startMonitoring(Process process) {
        if (process == null || !process.isAlive()) {
            logger.warn("Cannot monitor null or dead process");
            return;
        }
        this.stopMonitoring();
        if (this.config.isCaptureProcessOutput()) {
            this.outputMonitorFuture = this.startOutputMonitoring(process);
        }
        this.processMonitorFuture = this.startProcessMonitoring(process);
    }

    public void stopMonitoring() {
        if (this.outputMonitorFuture != null && !this.outputMonitorFuture.isDone()) {
            this.outputMonitorFuture.cancel(true);
            this.outputMonitorFuture = null;
        }
        if (this.processMonitorFuture != null && !this.processMonitorFuture.isDone()) {
            this.processMonitorFuture.cancel(true);
            this.processMonitorFuture = null;
        }
    }

    private CompletableFuture<Void> startOutputMonitoring(Process process) {
        return CompletableFuture.runAsync(() -> {
            block8: {
                logger.debug("Starting output monitoring for process");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while (!Thread.currentThread().isInterrupted() && (line = reader.readLine()) != null) {
                        this.logService.addLog(line);
                    }
                }
                catch (IOException e) {
                    if (Thread.currentThread().isInterrupted()) break block8;
                    logger.error("Error reading process output", (Throwable)e);
                }
            }
            logger.debug("Output monitoring stopped");
        }, this.executorService);
    }

    private CompletableFuture<Integer> startProcessMonitoring(Process process) {
        return CompletableFuture.supplyAsync(() -> {
            logger.debug("Starting process status monitoring");
            try {
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    logger.error("Uptrust server process terminated with exit code: {}", (Object)exitCode);
                } else {
                    logger.info("Uptrust server process terminated normally");
                }
                return exitCode;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.debug("Process monitoring interrupted");
                return -1;
            }
        }, this.executorService);
    }

    public Integer getExitCode() {
        if (this.processMonitorFuture != null && this.processMonitorFuture.isDone()) {
            try {
                return this.processMonitorFuture.getNow(null);
            }
            catch (Exception e) {
                logger.debug("Could not get exit code", (Throwable)e);
            }
        }
        return null;
    }

    @PreDestroy
    public void cleanup() {
        this.stopMonitoring();
        this.executorService.shutdownNow();
    }
}

