/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.core.lifecycle.status;

import net.savignano.uptrust.config.core.lifecycle.UptrustServerStatus;
import net.savignano.uptrust.config.core.lifecycle.config.LifecycleConfiguration;
import net.savignano.uptrust.config.core.lifecycle.health.HealthCheckClient;
import net.savignano.uptrust.config.core.lifecycle.process.ProcessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServerStatusResolver {
    private static final Logger logger = LoggerFactory.getLogger(ServerStatusResolver.class);
    private final ProcessManager processManager;
    private final HealthCheckClient healthCheckClient;
    private final LifecycleConfiguration config;

    public ServerStatusResolver(ProcessManager processManager, HealthCheckClient healthCheckClient, LifecycleConfiguration config) {
        this.processManager = processManager;
        this.healthCheckClient = healthCheckClient;
        this.config = config;
    }

    public UptrustServerStatus getCurrentStatus() {
        return this.waitForServerReady(0L, 100L);
    }

    public UptrustServerStatus waitForServerReady() {
        return this.waitForServerReady(this.config.getStartupTimeoutMs(), this.config.getHealthCheckPollIntervalMs());
    }

    public UptrustServerStatus waitForServerReady(long timeoutMs, long pollIntervalMs) {
        long endTime = System.currentTimeMillis() + timeoutMs;
        if (timeoutMs > 0L) {
            logger.info("Waiting for server to be ready (timeout: {}ms)", (Object)timeoutMs);
        }
        do {
            UptrustServerStatus status;
            if ((status = this.getActualStatus()) == UptrustServerStatus.RUNNING) {
                if (timeoutMs > 0L) {
                    logger.info("Server is ready and running");
                }
                return status;
            }
            if (status == UptrustServerStatus.NOT_RUNNING) {
                if (timeoutMs > 0L) {
                    logger.warn("Server process terminated during startup: {}", (Object)status);
                }
                return UptrustServerStatus.FAILED;
            }
            if (timeoutMs == 0L && status == UptrustServerStatus.INITIALIZING) {
                return status;
            }
            if (System.currentTimeMillis() >= endTime) continue;
            try {
                Thread.sleep(pollIntervalMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Interrupted while waiting for server ready");
                return UptrustServerStatus.FAILED;
            }
        } while (System.currentTimeMillis() < endTime);
        if (timeoutMs > 0L) {
            logger.error("Server startup timeout after {}ms", (Object)timeoutMs);
        }
        return UptrustServerStatus.FAILED;
    }

    private UptrustServerStatus getActualStatus() {
        if (!this.processManager.isProcessRunning()) {
            return UptrustServerStatus.NOT_RUNNING;
        }
        try {
            boolean isHealthy = this.healthCheckClient.isHealthy();
            logger.debug("Health check passed: {}", (Object)isHealthy);
            return isHealthy ? UptrustServerStatus.RUNNING : UptrustServerStatus.FAILED;
        }
        catch (Exception e) {
            logger.debug("Health check failed, server might be initializing", (Throwable)e);
            return UptrustServerStatus.INITIALIZING;
        }
    }

    public void validateNoOtherServerRunning() {
        try {
            if (this.healthCheckClient.isHealthy()) {
                throw new IllegalStateException("Another Uptrust server instance is already running. Please stop it before starting the config server.");
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("No other server detected (health check failed as expected)");
        }
    }
}

