/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.core.startup;

import java.io.IOException;
import java.util.Arrays;
import net.savignano.uptrust.config.features.general.model.UptrustDto;
import net.savignano.uptrust.config.features.keysource.model.KeySourceDto;
import net.savignano.uptrust.config.features.smtpimap.model.SmtpImapConfigDto;
import net.savignano.uptrust.config.features.smtpimap.repository.SmtpImapConfigRepository;
import net.savignano.uptrust.config.infrastructure.persistence.UptrustRepository;
import net.savignano.uptrust.config.infrastructure.storage.FileStorageService;
import net.savignano.uptrust.config.infrastructure.xml.XMLMapperService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class DatabaseInitializer
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseInitializer.class);
    @Autowired
    private UptrustRepository uptrustRepository;
    @Autowired
    private XMLMapperService xmlMapperService;
    @Autowired
    private FileStorageService fileStorageService;
    @Autowired
    private SmtpImapConfigRepository smtpImapConfigRepository;
    @Value(value="${uptrust.config.path}")
    private String fileSavePath;
    @Autowired
    private Environment environment;

    public void run(ApplicationArguments args) throws Exception {
        boolean initDb = args.containsOption("initdb");
        boolean isTestProfile = Arrays.asList(this.environment.getActiveProfiles()).contains("test");
        boolean isSeleniumTest = Boolean.getBoolean("selenium");
        if (isTestProfile && !isSeleniumTest) {
            logger.info("Skipping database initialization in test profile");
            return;
        }
        if (initDb || this.isDatabaseEmpty()) {
            this.initializeDatabase();
        }
    }

    public void initializeDatabase() {
        logger.info("Initializing database");
        this.loadUptrustDataFromXml();
        this.loadSmtpImapConfigFromXml();
        logger.info("Database initialized successfully");
    }

    private boolean isDatabaseEmpty() {
        return this.uptrustRepository.count() == 0L;
    }

    private void loadUptrustDataFromXml() {
        try {
            byte[] xmlBytes = this.fileStorageService.readConfigFile("uptrust.xml", this.fileSavePath);
            UptrustDto uptrustDto = this.xmlMapperService.getUptrustDtoFromBytes(xmlBytes);
            this.initializeKeysourcePriorities(uptrustDto);
            this.uptrustRepository.deleteAll();
            logger.info("Saving Uptrust configuration to database: {}", (Object)uptrustDto);
            this.uptrustRepository.save((Object)uptrustDto);
            logger.info("Database initialized from XML file");
        }
        catch (IOException e) {
            logger.error("Error initializing database from XML file", (Throwable)e);
            System.exit(1);
        }
    }

    private void initializeKeysourcePriorities(UptrustDto uptrustDto) {
        if (uptrustDto.getKeyManagement() != null && uptrustDto.getKeyManagement().getKeysources() != null) {
            int priority = 0;
            for (KeySourceDto keySource : uptrustDto.getKeyManagement().getKeysources()) {
                keySource.setPriority(Integer.valueOf(priority++));
            }
            logger.info("Initialized priorities for {} key sources", (Object)priority);
        }
    }

    public void loadSmtpImapConfigFromXml() {
        try {
            byte[] smtpXmlBytes = this.fileStorageService.readConfigFile("smtpserver.xml", this.fileSavePath);
            byte[] imapXmlBytes = this.fileStorageService.readConfigFile("imapserver.xml", this.fileSavePath);
            SmtpImapConfigDto smtpImapConfigDto = this.xmlMapperService.getSmtpImapConfigDtoFromBytes(smtpXmlBytes, imapXmlBytes);
            if (smtpImapConfigDto == null) {
                logger.error("Failed to load SMTP and IMAP configuration from XML files");
                System.exit(1);
            }
            SmtpImapConfigDto savedConfig = (SmtpImapConfigDto)this.smtpImapConfigRepository.save((Object)smtpImapConfigDto);
            logger.info("Loaded SMTP and IMAP configuration from XML files");
            return;
        }
        catch (IOException e) {
            logger.error("Failed to load SMTP and IMAP configuration from XML files", (Throwable)e);
            System.exit(1);
            return;
        }
    }
}

