/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.core.startup;

import java.io.IOException;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerService;
import net.savignano.uptrust.config.shared.exception.UptrustServerStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
@Profile(value={"!test"})
public class UptrustInitializer
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(UptrustInitializer.class);
    @Autowired
    private UptrustServerService uptrustServerService;

    public void run(ApplicationArguments args) throws Exception {
        logger.info("Initializing Uptrust Server");
        try {
            this.uptrustServerService.startServer();
            logger.info("Uptrust Server started successfully");
        }
        catch (IllegalStateException e) {
            logger.error("Failed to start Uptrust Server: {}", (Object)e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            logger.error("IO error while starting Uptrust Server: {}", (Object)e.getMessage());
        }
        catch (UptrustServerStatusException e) {
            logger.error("Failed to start Uptrust Server: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Failed to start Uptrust Server: {}", (Throwable)e);
        }
    }
}

