/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.applychanges.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.savignano.uptrust.config.features.applychanges.model.ApplyResultDto;
import net.savignano.uptrust.config.features.applychanges.service.ApplyService;
import net.savignano.uptrust.config.shared.model.ApiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/uptrust/apply"})
@Tag(name="Apply Changes", description="Configuration change application endpoints")
public class ApplyController {
    private static final Logger logger = LoggerFactory.getLogger(ApplyController.class);
    private final ApplyService applyService;

    @Autowired
    public ApplyController(ApplyService applyService) {
        this.applyService = applyService;
    }

    @PostMapping
    @Operation(summary="Apply configuration changes", description="Applies all pending configuration changes to the Uptrust gateway. This will restart the gateway service to activate the new configuration. Returns information about the operation including any startup errors or warnings.")
    public ResponseEntity<ApiResponse<ApplyResultDto>> applyChanges() throws Exception {
        logger.info("Received request to apply configuration changes");
        ApplyResultDto result = this.applyService.applyChanges();
        if (result.isHasStartupErrors()) {
            logger.error("Configuration applied with {} startup error(s)", (Object)result.getStartupErrorLogs().size());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((String)result.getMessage(), (Object)result));
        }
        if (result.isHasStartupWarnings()) {
            logger.warn("Configuration applied with {} startup warning(s)", (Object)result.getStartupWarningLogs().size());
        }
        if (!result.isHasStartupErrors() && !result.isHasStartupWarnings()) {
            logger.info("Configuration applied successfully without startup issues");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)ApiResponse.success((Object)result));
    }
}

