/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.applychanges.service;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import net.savignano.uptrust.config.core.lifecycle.StartupLogMonitor;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerService;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerStatus;
import net.savignano.uptrust.config.features.applychanges.model.ApplyResultDto;
import net.savignano.uptrust.config.features.general.model.UptrustDto;
import net.savignano.uptrust.config.features.smtpimap.model.SmtpImapConfigDto;
import net.savignano.uptrust.config.features.smtpimap.repository.SmtpImapConfigRepository;
import net.savignano.uptrust.config.infrastructure.logging.LogParser;
import net.savignano.uptrust.config.infrastructure.persistence.UptrustRepository;
import net.savignano.uptrust.config.infrastructure.storage.FileStorageService;
import net.savignano.uptrust.config.infrastructure.xml.XMLMapperService;
import net.savignano.uptrust.config.shared.exception.ConfigurationNotFoundException;
import net.savignano.uptrust.config.shared.exception.UptrustServerStatusException;
import net.savignano.uptrust.config.shared.service.ConfigStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApplyService {
    private static final Logger logger = LoggerFactory.getLogger(ApplyService.class);
    private final UptrustRepository uptrustRepository;
    private final FileStorageService fileStorageService;
    private final XMLMapperService xmlMapperService;
    private final UptrustServerService uptrustServerService;
    private final ConfigStateService configStateService;
    private final SmtpImapConfigRepository smtpImapConfigRepository;
    private final StartupLogMonitor startupLogMonitor;
    private final LogParser logParser;
    @Value(value="${uptrust.config.path}")
    private String fileSavePath;

    @Autowired
    public ApplyService(UptrustRepository uptrustRepository, FileStorageService fileStorageService, XMLMapperService xmlMapperService, UptrustServerService uptrustServerService, ConfigStateService configStateService, SmtpImapConfigRepository smtpImapConfigRepository, StartupLogMonitor startupLogMonitor, LogParser logParser) {
        this.smtpImapConfigRepository = smtpImapConfigRepository;
        this.uptrustRepository = uptrustRepository;
        this.fileStorageService = fileStorageService;
        this.xmlMapperService = xmlMapperService;
        this.uptrustServerService = uptrustServerService;
        this.configStateService = configStateService;
        this.startupLogMonitor = startupLogMonitor;
        this.logParser = logParser;
    }

    public ApplyResultDto applyChanges() throws IOException, UptrustServerStatusException, Exception {
        logger.info("Starting to apply configuration changes");
        Optional uptrustDto = this.uptrustRepository.findTopByOrderByUuidAsc();
        if (uptrustDto.isEmpty()) {
            logger.error("No Uptrust configuration found to apply");
            throw new ConfigurationNotFoundException("No Uptrust configuration found");
        }
        try {
            byte[] xmlBytes = this.xmlMapperService.getBytesFromUptrustDto((UptrustDto)uptrustDto.get());
            this.fileStorageService.saveConfigFile(xmlBytes, "uptrust.xml", this.fileSavePath);
            logger.info("Configuration saved to XML file");
        }
        catch (Exception e) {
            logger.error("Failed to save Uptrust configuration file", (Throwable)e);
            throw e;
        }
        try {
            Optional smtpImapConfig = this.smtpImapConfigRepository.findTopByOrderByIdAsc();
            if (smtpImapConfig.isPresent()) {
                this.fileStorageService.saveConfigFile(((SmtpImapConfigDto)smtpImapConfig.get()).getSmtpXmlContent().getBytes(), "smtpserver.xml", this.fileSavePath);
                this.fileStorageService.saveConfigFile(((SmtpImapConfigDto)smtpImapConfig.get()).getImapXmlContent().getBytes(), "imapserver.xml", this.fileSavePath);
                logger.info("SMTP and IMAP configurations saved to XML files");
            } else {
                logger.warn("No SMTP and IMAP configuration found to apply");
            }
        }
        catch (Exception e) {
            logger.error("Failed to save SMTP/IMAP configuration files", (Throwable)e);
            throw e;
        }
        LocalDateTime restartStartTime = LocalDateTime.now();
        UptrustServerStatus finalStatus = this.uptrustServerService.restartServer();
        List errorLogs = this.startupLogMonitor.getErrorLogsSince(restartStartTime);
        List warningLogs = this.startupLogMonitor.getWarningLogsSince(restartStartTime);
        List structuredErrorLogs = this.logParser.parseLogMessages(errorLogs);
        List structuredWarningLogs = this.logParser.parseLogMessages(warningLogs);
        this.configStateService.resetUnappliedChanges();
        if (structuredErrorLogs.isEmpty() && structuredWarningLogs.isEmpty()) {
            logger.info("Configuration changes applied successfully without errors or warnings");
            return ApplyResultDto.success();
        }
        if (!structuredErrorLogs.isEmpty()) {
            logger.warn("Configuration changes applied but {} error(s) detected during startup", (Object)structuredErrorLogs.size());
        }
        if (!structuredWarningLogs.isEmpty()) {
            logger.info("Configuration changes applied with {} warning(s) during startup", (Object)structuredWarningLogs.size());
        }
        return ApplyResultDto.successWithIssues((List)structuredErrorLogs, (List)structuredWarningLogs);
    }
}

