/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.auth.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import net.savignano.uptrust.config.features.auth.model.ChangePasswordRequest;
import net.savignano.uptrust.config.features.auth.model.LoginRequest;
import net.savignano.uptrust.config.features.auth.model.UserResponse;
import net.savignano.uptrust.config.features.auth.service.AuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/auth"})
@Tag(name="Authentication", description="User authentication and session management endpoints")
public class AuthController {
    private static final Logger logger = LoggerFactory.getLogger(AuthController.class);
    private static final String DEFAULT_USERNAME = "admin";
    private final AuthService authService;

    @Autowired
    public AuthController(AuthService authService) {
        this.authService = authService;
    }

    @PostMapping(value={"/login"})
    @Operation(summary="User login", description="Authenticates a user with username and password, creating a new session")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Login successful"), @ApiResponse(responseCode="401", description="Invalid credentials"), @ApiResponse(responseCode="429", description="Too many login attempts")})
    public ResponseEntity<String> login(@Parameter(description="Login credentials") @RequestBody LoginRequest request, HttpSession session, HttpServletRequest httpRequest) {
        ResponseEntity result = this.authService.authenticate(request.getUsername(), request.getPassword(), httpRequest.getRemoteAddr());
        if (result.getStatusCode() == HttpStatus.OK) {
            session.setAttribute("authenticated", (Object)true);
        }
        return result;
    }

    @PostMapping(value={"/logout"})
    @Operation(summary="User logout", description="Invalidates the current user session and logs out")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Logout successful")})
    public ResponseEntity<String> logout(HttpSession session) {
        session.invalidate();
        return ResponseEntity.ok((Object)"Logged out");
    }

    @PutMapping(value={"/change-password"})
    @Operation(summary="Change password", description="Updates the current user's password")
    public ResponseEntity<String> changePassword(@Parameter(description="Password change request") @RequestBody ChangePasswordRequest request, HttpSession session, HttpServletRequest httpRequest) {
        if (session.getAttribute("authenticated") == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Not authenticated");
        }
        return this.authService.changePassword(request.getOldPassword(), request.getNewPassword(), httpRequest.getRemoteAddr());
    }

    @GetMapping(value={"/user"}, produces={"application/json"})
    @Operation(summary="Get current user", description="Retrieves information about the currently authenticated user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User information retrieved successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserResponse.class))}), @ApiResponse(responseCode="401", description="Not authenticated")})
    public ResponseEntity<UserResponse> getUser(HttpSession session) {
        if (session.getAttribute("authenticated") == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(null);
        }
        return ResponseEntity.ok((Object)new UserResponse(DEFAULT_USERNAME));
    }

    @GetMapping(value={"/test/reset-rate-limit"})
    @ConditionalOnProperty(name={"spring.profiles.active"}, havingValue="test")
    public ResponseEntity<String> resetRateLimit(HttpServletRequest request) {
        logger.info("Resetting rate limit for IP: {}", (Object)request.getRemoteAddr());
        String clientIP = request.getRemoteAddr();
        this.authService.resetBucket(clientIP);
        return ResponseEntity.ok((Object)("Rate limit reset for IP: " + clientIP));
    }
}

