/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.domainkey.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerService;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerStatus;
import net.savignano.uptrust.config.features.domainkey.model.DomainKeyDto;
import net.savignano.uptrust.config.features.domainkey.service.DomainKeyService;
import net.savignano.uptrust.config.shared.model.ApiResponse;
import net.savignano.uptrust.config.shared.service.ConfigStateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/uptrust/domainkeys"})
@Tag(name="Domain Keys", description="Domain key configuration management endpoints")
public class DomainKeyController {
    private final DomainKeyService domainKeyService;
    private final ConfigStateService configStateService;
    private final UptrustServerService uptrustServerService;

    @Autowired
    public DomainKeyController(DomainKeyService domainKeyService, ConfigStateService configStateService, UptrustServerService uptrustServerService) {
        this.domainKeyService = domainKeyService;
        this.configStateService = configStateService;
        this.uptrustServerService = uptrustServerService;
    }

    @GetMapping
    @Operation(summary="Get all domain keys", description="Retrieves all configured domain keys for email encryption and signing. Domain keys are associated with specific email domains.")
    public ResponseEntity<ApiResponse<List<DomainKeyDto>>> getDomainKeys() {
        List keys = this.domainKeyService.getDomainKeys();
        return ResponseEntity.ok((Object)ApiResponse.success((Object)keys, (boolean)this.configStateService.hasUnappliedChanges(), (UptrustServerStatus)this.uptrustServerService.getServerStatus()));
    }

    @PostMapping(consumes={"application/json"})
    @Operation(summary="Create new domain key", description="Creates a new domain key configuration for a specific email domain. Supports both PGP and S/MIME key types.")
    public ResponseEntity<ApiResponse<DomainKeyDto>> addDomainKey(@Parameter(description="Domain key configuration data", required=true) @RequestBody DomainKeyDto domainKey) {
        DomainKeyDto saved = this.domainKeyService.addDomainKey(domainKey);
        this.configStateService.markUnappliedChanges();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)ApiResponse.success((Object)saved, (boolean)true));
    }

    @PutMapping(value={"/{uuid}"}, consumes={"application/json"})
    @Operation(summary="Update domain key", description="Updates an existing domain key configuration. Allows modification of email domain and key type.")
    public ResponseEntity<ApiResponse<Void>> updateDomainKey(@Parameter(description="UUID of the domain key to update", required=true) @PathVariable(value="uuid") String uuid, @Parameter(description="Updated domain key configuration data", required=true) @RequestBody DomainKeyDto domainKey) {
        this.domainKeyService.updateDomainKey(uuid, domainKey);
        this.configStateService.markUnappliedChanges();
        return ResponseEntity.ok((Object)ApiResponse.success(null, (boolean)true));
    }

    @DeleteMapping(value={"/{uuid}"})
    @Operation(summary="Delete domain key", description="Deletes an existing domain key configuration. This will permanently remove the domain key association.")
    public ResponseEntity<ApiResponse<Void>> deleteDomainKey(@Parameter(description="UUID of the domain key to delete", required=true) @PathVariable(value="uuid") String uuid) {
        this.domainKeyService.deleteDomainKey(uuid);
        this.configStateService.markUnappliedChanges();
        return ResponseEntity.ok((Object)ApiResponse.success(null, (boolean)true));
    }
}

