/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.domainkey.service;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.savignano.uptrust.config.features.domainkey.model.DomainKeyDto;
import net.savignano.uptrust.config.features.general.model.UptrustDto;
import net.savignano.uptrust.config.infrastructure.persistence.UptrustRepository;
import net.savignano.uptrust.config.shared.exception.ConfigurationNotFoundException;
import net.savignano.uptrust.config.shared.exception.DomainKeyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DomainKeyService {
    private static final Logger logger = LoggerFactory.getLogger(DomainKeyService.class);
    private final UptrustRepository uptrustRepository;

    @Autowired
    public DomainKeyService(UptrustRepository uptrustRepository) {
        this.uptrustRepository = uptrustRepository;
    }

    public List<DomainKeyDto> getDomainKeys() {
        return this.uptrustRepository.findTopByOrderByUuidAsc().map(uptrust -> uptrust.getKeyManagement().getDomainkeys().stream().sorted(Comparator.comparing(DomainKeyDto::getEmail)).collect(Collectors.toList())).orElseThrow(() -> new ConfigurationNotFoundException("Cannot retrieve domain keys - Uptrust configuration not found"));
    }

    public DomainKeyDto addDomainKey(DomainKeyDto domainKey) {
        UptrustDto uptrust = (UptrustDto)this.uptrustRepository.findTopByOrderByUuidAsc().orElseThrow(() -> new ConfigurationNotFoundException("Cannot add domain key - Uptrust configuration not found"));
        List domainKeys = uptrust.getKeyManagement().getDomainkeys();
        domainKeys.add(domainKey);
        this.uptrustRepository.save((Object)uptrust);
        logger.info("Added new domain key");
        return domainKey;
    }

    public void updateDomainKey(String uuid, DomainKeyDto domainKey) {
        UptrustDto uptrust = (UptrustDto)this.uptrustRepository.findTopByOrderByUuidAsc().orElseThrow(() -> new ConfigurationNotFoundException("Cannot update domain key - Uptrust configuration not found"));
        List domainKeys = uptrust.getKeyManagement().getDomainkeys();
        Optional<DomainKeyDto> existingKey = domainKeys.stream().filter(dk -> dk.getUuid().equals(uuid)).findFirst();
        if (existingKey.isEmpty()) {
            logger.warn("Domain key with UUID {} not found", (Object)uuid);
            throw new DomainKeyNotFoundException(uuid);
        }
        int index = domainKeys.indexOf(existingKey.get());
        domainKeys.set(index, domainKey);
        this.uptrustRepository.save((Object)uptrust);
        logger.info("Updated domain key with UUID: {}", (Object)uuid);
    }

    public void deleteDomainKey(String uuid) {
        UptrustDto uptrust = (UptrustDto)this.uptrustRepository.findTopByOrderByUuidAsc().orElseThrow(() -> new ConfigurationNotFoundException("Cannot delete domain key - Uptrust configuration not found"));
        List domainKeys = uptrust.getKeyManagement().getDomainkeys();
        boolean removed = domainKeys.removeIf(dk -> dk.getUuid().equals(uuid));
        if (!removed) {
            logger.warn("Domain key with UUID {} not found", (Object)uuid);
            throw new DomainKeyNotFoundException(uuid);
        }
        this.uptrustRepository.save((Object)uptrust);
        logger.info("Deleted domain key with UUID: {}", (Object)uuid);
    }
}

