/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.general.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerService;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerStatus;
import net.savignano.uptrust.config.features.general.model.UptrustConfigStatusDto;
import net.savignano.uptrust.config.features.general.model.UptrustDto;
import net.savignano.uptrust.config.features.general.service.GeneralService;
import net.savignano.uptrust.config.features.general.validation.GeneralValidator;
import net.savignano.uptrust.config.shared.exception.ValidationException;
import net.savignano.uptrust.config.shared.model.ApiResponse;
import net.savignano.uptrust.config.shared.service.ConfigStateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="General", description="Uptrust general configuration management endpoints")
@RequestMapping(value={"/api/v1/uptrust/general"})
public class GeneralController {
    private final GeneralService generalService;
    private final ConfigStateService configStateService;
    private final GeneralValidator generalValidator;
    private final UptrustServerService uptrustServerService;

    @Autowired
    public GeneralController(GeneralService generalService, ConfigStateService configStateService, GeneralValidator generalValidator, UptrustServerService uptrustServerService) {
        this.generalService = generalService;
        this.configStateService = configStateService;
        this.generalValidator = generalValidator;
        this.uptrustServerService = uptrustServerService;
    }

    @Operation(summary="Get Uptrust configuration", description="Retrieves the current Uptrust configuration settings including cryptography settings, key management, and server status")
    @GetMapping(produces={"application/json"})
    public ResponseEntity<ApiResponse<UptrustConfigStatusDto>> getUptrustConfig() {
        return this.generalService.getUptrustConfig().map(config -> ResponseEntity.ok((Object)ApiResponse.success((Object)config, (boolean)this.configStateService.hasUnappliedChanges(), (UptrustServerStatus)this.uptrustServerService.getServerStatus()))).orElse(ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((String)"CONFIG_NOT_FOUND", (UptrustServerStatus)this.uptrustServerService.getServerStatus())));
    }

    @PutMapping(consumes={"application/json"})
    @Operation(summary="Update Uptrust configuration", description="Updates the Uptrust configuration settings. This will mark the configuration as having unapplied changes that need to be applied to take effect.")
    public ResponseEntity<ApiResponse<Void>> updateConfig(@Parameter(description="Updated Uptrust configuration data", required=true) @RequestBody UptrustDto uptrustDto) {
        List validationErrors = this.generalValidator.validate(uptrustDto);
        if (!validationErrors.isEmpty()) {
            throw new ValidationException("General configuration", validationErrors);
        }
        boolean updated = this.generalService.updateConfig(uptrustDto);
        if (updated) {
            this.configStateService.markUnappliedChanges();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)ApiResponse.success(null, (boolean)true));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((String)"CONFIG_NOT_FOUND"));
    }
}

