/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.general.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.util.List;
import net.savignano.uptrust.config.features.domainkey.model.DomainKeyDto;
import net.savignano.uptrust.config.features.general.model.KeyManagementDto;
import net.savignano.uptrust.config.features.keysource.model.KeySourceDto;

@Entity
@Table(name="CONFIG_KEY_MANAGEMENT")
public class KeyManagementDto {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    @JsonIgnore
    private String uuid;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="KEYSOURCE_ID")
    @JacksonXmlElementWrapper(localName="keysources")
    @JacksonXmlProperty(localName="keysource")
    @OrderBy(value="priority ASC")
    private List<KeySourceDto> keysources;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="DOMAIN_KEY_ID")
    @JacksonXmlElementWrapper(localName="domainkeys")
    @JacksonXmlProperty(localName="email")
    private List<DomainKeyDto> domainkeys;

    public static KeyManagementDtoBuilder builder() {
        return new KeyManagementDtoBuilder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public List<KeySourceDto> getKeysources() {
        return this.keysources;
    }

    public List<DomainKeyDto> getDomainkeys() {
        return this.domainkeys;
    }

    @JsonIgnore
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @JacksonXmlElementWrapper(localName="keysources")
    @JacksonXmlProperty(localName="keysource")
    public void setKeysources(List<KeySourceDto> keysources) {
        this.keysources = keysources;
    }

    @JacksonXmlElementWrapper(localName="domainkeys")
    @JacksonXmlProperty(localName="email")
    public void setDomainkeys(List<DomainKeyDto> domainkeys) {
        this.domainkeys = domainkeys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyManagementDto)) {
            return false;
        }
        KeyManagementDto other = (KeyManagementDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        List this$keysources = this.getKeysources();
        List other$keysources = other.getKeysources();
        if (this$keysources == null ? other$keysources != null : !((Object)this$keysources).equals(other$keysources)) {
            return false;
        }
        List this$domainkeys = this.getDomainkeys();
        List other$domainkeys = other.getDomainkeys();
        return !(this$domainkeys == null ? other$domainkeys != null : !((Object)this$domainkeys).equals(other$domainkeys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyManagementDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        List $keysources = this.getKeysources();
        result = result * 59 + ($keysources == null ? 43 : ((Object)$keysources).hashCode());
        List $domainkeys = this.getDomainkeys();
        result = result * 59 + ($domainkeys == null ? 43 : ((Object)$domainkeys).hashCode());
        return result;
    }

    public String toString() {
        return "KeyManagementDto(uuid=" + this.getUuid() + ", keysources=" + String.valueOf(this.getKeysources()) + ", domainkeys=" + String.valueOf(this.getDomainkeys()) + ")";
    }

    public KeyManagementDto() {
    }

    public KeyManagementDto(String uuid, List<KeySourceDto> keysources, List<DomainKeyDto> domainkeys) {
        this.uuid = uuid;
        this.keysources = keysources;
        this.domainkeys = domainkeys;
    }
}

