/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.general.service;

import java.util.List;
import java.util.Optional;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerService;
import net.savignano.uptrust.config.features.general.model.UptrustConfigStatusDto;
import net.savignano.uptrust.config.features.general.model.UptrustDto;
import net.savignano.uptrust.config.features.general.validation.GeneralValidator;
import net.savignano.uptrust.config.infrastructure.persistence.UptrustRepository;
import net.savignano.uptrust.config.shared.exception.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeneralService {
    private final UptrustRepository uptrustRepository;
    private final GeneralValidator generalValidator;
    private final UptrustServerService uptrustServerService;

    @Autowired
    public GeneralService(UptrustRepository uptrustRepository, GeneralValidator generalValidator, UptrustServerService uptrustServerService) {
        this.uptrustRepository = uptrustRepository;
        this.generalValidator = generalValidator;
        this.uptrustServerService = uptrustServerService;
    }

    public Optional<UptrustConfigStatusDto> getUptrustConfig() {
        Optional config = this.uptrustRepository.findTopByOrderByUuidAsc();
        return config.map(uptrustDto -> new UptrustConfigStatusDto(uptrustDto, this.uptrustServerService.getServerStatus()));
    }

    public boolean updateConfig(UptrustDto uptrustDto) {
        List validationErrors = this.generalValidator.validate(uptrustDto);
        if (!validationErrors.isEmpty()) {
            throw new ValidationException("Uptrust general configuration", validationErrors);
        }
        Optional existingConfig = this.uptrustRepository.findTopByOrderByUuidAsc();
        if (existingConfig.isPresent()) {
            this.updateUptrustAttributes((UptrustDto)existingConfig.get(), uptrustDto);
            this.uptrustRepository.save((Object)((UptrustDto)existingConfig.get()));
            return true;
        }
        return false;
    }

    private void updateUptrustAttributes(UptrustDto existingUptrust, UptrustDto updatedUptrust) {
        existingUptrust.setEnabled(updatedUptrust.isEnabled());
        existingUptrust.setIncomingMail(updatedUptrust.getIncomingMail());
        existingUptrust.setOutgoingMail(updatedUptrust.getOutgoingMail());
        existingUptrust.setDecoration(updatedUptrust.getDecoration());
        existingUptrust.setCryptography(updatedUptrust.getCryptography());
    }
}

