/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.general.validation;

import java.util.ArrayList;
import java.util.List;
import net.savignano.uptrust.config.features.general.model.CryptographyDto;
import net.savignano.uptrust.config.features.general.model.DecorationDto;
import net.savignano.uptrust.config.features.general.model.DecryptionDto;
import net.savignano.uptrust.config.features.general.model.EncryptionDto;
import net.savignano.uptrust.config.features.general.model.IncomingMailDto;
import net.savignano.uptrust.config.features.general.model.OutgoingMailDto;
import net.savignano.uptrust.config.features.general.model.UptrustDto;
import org.springframework.stereotype.Component;

@Component
public class GeneralValidator {
    public List<String> validate(UptrustDto uptrust) {
        ArrayList<String> errors = new ArrayList<String>();
        if (uptrust == null) {
            errors.add("CONFIG_GENERAL_NULL");
            return errors;
        }
        this.validateCryptography(uptrust.getCryptography(), errors);
        if (uptrust.getIncomingMail() == null) {
            errors.add("CONFIG_INCOMING_MAIL_REQUIRED");
        } else {
            this.validateIncomingMail(uptrust.getIncomingMail(), errors);
        }
        if (uptrust.getOutgoingMail() == null) {
            errors.add("CONFIG_OUTGOING_MAIL_REQUIRED");
        } else {
            this.validateOutgoingMail(uptrust.getOutgoingMail(), errors);
        }
        if (uptrust.getDecoration() == null) {
            errors.add("CONFIG_DECORATION_REQUIRED");
        } else {
            this.validateDecoration(uptrust.getDecoration(), errors);
        }
        return errors;
    }

    private void validateCryptography(CryptographyDto cryptography, List<String> errors) {
        if (cryptography == null) {
            errors.add("CONFIG_CRYPTOGRAPHY_REQUIRED");
            return;
        }
        if (cryptography.getEncryption() == null) {
            errors.add("CONFIG_ENCRYPTION_REQUIRED");
        } else {
            this.validateEncryption(cryptography.getEncryption(), errors);
        }
        if (cryptography.getDecryption() == null) {
            errors.add("CONFIG_DECRYPTION_REQUIRED");
        } else {
            this.validateDecryption(cryptography.getDecryption(), errors);
        }
        if (cryptography.getValidation() == null) {
            errors.add("CONFIG_VALIDATION_REQUIRED");
        }
    }

    private void validateEncryption(EncryptionDto encryption, List<String> errors) {
    }

    private void validateDecryption(DecryptionDto decryption, List<String> errors) {
        if (decryption.isPgpCheckInline() && (decryption.getPgpBinaryRegex() == null || decryption.getPgpBinaryRegex().trim().isEmpty())) {
            errors.add("CONFIG_PGP_REGEX_REQUIRED");
        }
    }

    private void validateIncomingMail(IncomingMailDto incomingMail, List<String> errors) {
    }

    private void validateOutgoingMail(OutgoingMailDto outgoingMail, List<String> errors) {
        if (outgoingMail.getProtection() == null) {
            errors.add("CONFIG_PROTECTION_TYPE_REQUIRED");
        }
        if (outgoingMail.getProtectionFailureBehaviour() == null) {
            errors.add("CONFIG_PROTECTION_FAILURE_BEHAVIOUR_REQUIRED");
        }
    }

    private void validateDecoration(DecorationDto decoration, List<String> errors) {
        if (decoration.getInsertProtectionIndicators() == null) {
            errors.add("CONFIG_PROTECTION_INDICATORS_REQUIRED");
        }
        if (decoration.getInsertProtectionIndicators() != DecorationDto.InsertProtectionIndicators.NEVER && decoration.getProtectionIndicatorLocation() == null) {
            errors.add("CONFIG_INDICATOR_LOCATION_REQUIRED");
        }
    }
}

