/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.keysource.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerService;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerStatus;
import net.savignano.uptrust.config.features.keysource.model.KeySourceDto;
import net.savignano.uptrust.config.features.keysource.service.KeySourceService;
import net.savignano.uptrust.config.shared.model.ApiResponse;
import net.savignano.uptrust.config.shared.service.ConfigStateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/uptrust/keysources"})
@Tag(name="Key Sources", description="Key source configuration management endpoints")
public class KeySourceController {
    private final KeySourceService keySourceService;
    private final ConfigStateService configStateService;
    private final UptrustServerService uptrustServerService;

    @Autowired
    public KeySourceController(KeySourceService keySourceService, ConfigStateService configStateService, UptrustServerService uptrustServerService) {
        this.keySourceService = keySourceService;
        this.configStateService = configStateService;
        this.uptrustServerService = uptrustServerService;
    }

    @GetMapping
    @Operation(summary="Get all key sources", description="Retrieves all configured key sources with their current priority order and configuration details")
    public ResponseEntity<ApiResponse<List<KeySourceDto>>> getKeySources() {
        List keySources = this.keySourceService.getAllKeySources();
        return ResponseEntity.ok((Object)ApiResponse.success((Object)keySources, (boolean)this.configStateService.hasUnappliedChanges(), (UptrustServerStatus)this.uptrustServerService.getServerStatus()));
    }

    @PostMapping(consumes={"multipart/form-data"})
    @Operation(summary="Create new key source", description="Creates a new key source configuration. Supports file uploads for keystore files and automatically assigns priority based on existing key sources.")
    public ResponseEntity<ApiResponse<KeySourceDto>> addKeySource(@Parameter(description="Key source configuration data with optional file upload") @ModelAttribute KeySourceDto keySource) {
        KeySourceDto savedKeySource = this.keySourceService.addKeySource(keySource);
        this.configStateService.markUnappliedChanges();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)ApiResponse.success((Object)savedKeySource, (boolean)true));
    }

    @PutMapping(value={"/{uuid}"}, consumes={"multipart/form-data"})
    @Operation(summary="Update key source", description="Updates an existing key source configuration. Supports updating configuration parameters and uploading new keystore files.")
    public ResponseEntity<ApiResponse<KeySourceDto>> updateKeySource(@Parameter(description="UUID of the key source to update", required=true) @PathVariable(value="uuid") String uuid, @Parameter(description="Updated key source configuration data with optional file upload") @ModelAttribute KeySourceDto keySource) {
        KeySourceDto updatedKeySourceDto = this.keySourceService.updateKeySource(uuid, keySource);
        this.configStateService.markUnappliedChanges();
        return ResponseEntity.ok((Object)ApiResponse.success((Object)updatedKeySourceDto, (boolean)true));
    }

    @DeleteMapping(value={"/{uuid}"})
    @Operation(summary="Delete key source", description="Deletes an existing key source configuration. This will permanently remove the key source and any associated files.")
    public ResponseEntity<ApiResponse<Void>> deleteKeySource(@Parameter(description="UUID of the key source to delete", required=true) @PathVariable(value="uuid") String uuid) {
        this.keySourceService.deleteKeySource(uuid);
        this.configStateService.markUnappliedChanges();
        return ResponseEntity.ok((Object)ApiResponse.success(null, (boolean)true));
    }

    @PostMapping(value={"/{uuid}/moveup"})
    @Operation(summary="Move key source up", description="Moves a key source up in the priority order. Higher priority key sources are checked first when looking for keys.")
    public ResponseEntity<ApiResponse<KeySourceDto>> moveKeySourceUp(@Parameter(description="UUID of the key source to move up", required=true) @PathVariable(value="uuid") String uuid) {
        KeySourceDto movedKeySource = this.keySourceService.moveKeySourceUp(uuid);
        this.configStateService.markUnappliedChanges();
        return ResponseEntity.ok((Object)ApiResponse.success((Object)movedKeySource, (boolean)true));
    }

    @PostMapping(value={"/{uuid}/movedown"})
    @Operation(summary="Move key source down", description="Moves a key source down in the priority order. Lower priority key sources are checked later when looking for keys.")
    public ResponseEntity<ApiResponse<KeySourceDto>> moveKeySourceDown(@Parameter(description="UUID of the key source to move down", required=true) @PathVariable(value="uuid") String uuid) {
        KeySourceDto movedKeySource = this.keySourceService.moveKeySourceDown(uuid);
        this.configStateService.markUnappliedChanges();
        return ResponseEntity.ok((Object)ApiResponse.success((Object)movedKeySource, (boolean)true));
    }
}

