/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.keysource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import net.savignano.uptrust.config.features.keysource.model.KeySourceConfigAuthDto;
import net.savignano.uptrust.config.features.keysource.model.KeySourceConfigDto;
import net.savignano.uptrust.config.features.keysource.model.KeySourceConfigEnvDto;
import net.savignano.uptrust.config.features.keysource.model.serializer.KeySourceConfigEnvWrapperDtoDeserializer;
import net.savignano.uptrust.config.features.keysource.model.serializer.KeySourceConfigEnvWrapperDtoSerializer;
import net.savignano.uptrust.config.infrastructure.model.PasswordDto;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="CONFIG_KEY_SOURCE_CONFIG")
public class KeySourceConfigDto {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    @JsonIgnore
    private String uuid;
    @JacksonXmlProperty(localName="file")
    private String file;
    @Transient
    @JsonIgnore
    private MultipartFile fileUpload;
    @JacksonXmlProperty(localName="url")
    private String url;
    @JacksonXmlProperty(localName="type")
    private KeySourceConfigKeystoreType type;
    @Column(name="password")
    private String password;
    @JsonIgnore
    @Column(name="password_cipher")
    private String passwordCipher;
    @JacksonXmlProperty(localName="encodeSearchParam")
    private boolean encodeSearchParam;
    @JacksonXmlProperty(localName="timeout")
    private Integer timeout;
    @JacksonXmlProperty(localName="hostURL")
    private String hostURL;
    @JacksonXmlProperty(localName="baseDN")
    private String baseDN;
    @JacksonXmlProperty(localName="emailAttribute")
    private String emailAttribute;
    @JacksonXmlProperty(localName="filter")
    private String filter;
    @JacksonXmlProperty(localName="disableTrustCheck")
    private boolean disableTrustCheck;
    @JacksonXmlProperty(localName="auth")
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    private KeySourceConfigAuthDto auth;
    @JacksonXmlElementWrapper(useWrapping=false)
    @JsonDeserialize(using=KeySourceConfigEnvWrapperDtoDeserializer.class)
    @JsonSerialize(using=KeySourceConfigEnvWrapperDtoSerializer.class)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<KeySourceConfigEnvDto> env;

    @JacksonXmlProperty(localName="password")
    public PasswordDto getPasswordForXml() {
        if (this.password == null) {
            return null;
        }
        return this.passwordCipher != null ? PasswordDto.encrypted((String)this.password, (String)this.passwordCipher) : PasswordDto.plaintext((String)this.password);
    }

    public String toString() {
        return "KeySourceConfigDto(uuid=" + this.uuid + ", file=" + this.file + ", url=" + this.url + ", type=" + String.valueOf(this.type) + ", password=" + (this.password != null && !this.password.isEmpty() ? "********" : this.password) + ", encodeSearchParam=" + this.encodeSearchParam + ", timeout=" + this.timeout + ", hostURL=" + this.hostURL + ", baseDN=" + this.baseDN + ", emailAttribute=" + this.emailAttribute + ", filter=" + this.filter + ", disableTrustCheck=" + this.disableTrustCheck + ", auth=" + String.valueOf(this.auth) + ", env=" + String.valueOf(this.env) + ")";
    }

    public static KeySourceConfigDtoBuilder builder() {
        return new KeySourceConfigDtoBuilder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getFile() {
        return this.file;
    }

    public MultipartFile getFileUpload() {
        return this.fileUpload;
    }

    public String getUrl() {
        return this.url;
    }

    public KeySourceConfigKeystoreType getType() {
        return this.type;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordCipher() {
        return this.passwordCipher;
    }

    public boolean isEncodeSearchParam() {
        return this.encodeSearchParam;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getHostURL() {
        return this.hostURL;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isDisableTrustCheck() {
        return this.disableTrustCheck;
    }

    public KeySourceConfigAuthDto getAuth() {
        return this.auth;
    }

    public List<KeySourceConfigEnvDto> getEnv() {
        return this.env;
    }

    @JsonIgnore
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @JacksonXmlProperty(localName="file")
    public void setFile(String file) {
        this.file = file;
    }

    @JsonIgnore
    public void setFileUpload(MultipartFile fileUpload) {
        this.fileUpload = fileUpload;
    }

    @JacksonXmlProperty(localName="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JacksonXmlProperty(localName="type")
    public void setType(KeySourceConfigKeystoreType type) {
        this.type = type;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @JsonIgnore
    public void setPasswordCipher(String passwordCipher) {
        this.passwordCipher = passwordCipher;
    }

    @JacksonXmlProperty(localName="encodeSearchParam")
    public void setEncodeSearchParam(boolean encodeSearchParam) {
        this.encodeSearchParam = encodeSearchParam;
    }

    @JacksonXmlProperty(localName="timeout")
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @JacksonXmlProperty(localName="hostURL")
    public void setHostURL(String hostURL) {
        this.hostURL = hostURL;
    }

    @JacksonXmlProperty(localName="baseDN")
    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    @JacksonXmlProperty(localName="emailAttribute")
    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    @JacksonXmlProperty(localName="filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @JacksonXmlProperty(localName="disableTrustCheck")
    public void setDisableTrustCheck(boolean disableTrustCheck) {
        this.disableTrustCheck = disableTrustCheck;
    }

    @JacksonXmlProperty(localName="auth")
    public void setAuth(KeySourceConfigAuthDto auth) {
        this.auth = auth;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JsonDeserialize(using=KeySourceConfigEnvWrapperDtoDeserializer.class)
    public void setEnv(List<KeySourceConfigEnvDto> env) {
        this.env = env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeySourceConfigDto)) {
            return false;
        }
        KeySourceConfigDto other = (KeySourceConfigDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEncodeSearchParam() != other.isEncodeSearchParam()) {
            return false;
        }
        if (this.isDisableTrustCheck() != other.isDisableTrustCheck()) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        MultipartFile this$fileUpload = this.getFileUpload();
        MultipartFile other$fileUpload = other.getFileUpload();
        if (this$fileUpload == null ? other$fileUpload != null : !this$fileUpload.equals(other$fileUpload)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        KeySourceConfigKeystoreType this$type = this.getType();
        KeySourceConfigKeystoreType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$passwordCipher = this.getPasswordCipher();
        String other$passwordCipher = other.getPasswordCipher();
        if (this$passwordCipher == null ? other$passwordCipher != null : !this$passwordCipher.equals(other$passwordCipher)) {
            return false;
        }
        String this$hostURL = this.getHostURL();
        String other$hostURL = other.getHostURL();
        if (this$hostURL == null ? other$hostURL != null : !this$hostURL.equals(other$hostURL)) {
            return false;
        }
        String this$baseDN = this.getBaseDN();
        String other$baseDN = other.getBaseDN();
        if (this$baseDN == null ? other$baseDN != null : !this$baseDN.equals(other$baseDN)) {
            return false;
        }
        String this$emailAttribute = this.getEmailAttribute();
        String other$emailAttribute = other.getEmailAttribute();
        if (this$emailAttribute == null ? other$emailAttribute != null : !this$emailAttribute.equals(other$emailAttribute)) {
            return false;
        }
        String this$filter = this.getFilter();
        String other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        KeySourceConfigAuthDto this$auth = this.getAuth();
        KeySourceConfigAuthDto other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        List this$env = this.getEnv();
        List other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !((Object)this$env).equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeySourceConfigDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEncodeSearchParam() ? 79 : 97);
        result = result * 59 + (this.isDisableTrustCheck() ? 79 : 97);
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        MultipartFile $fileUpload = this.getFileUpload();
        result = result * 59 + ($fileUpload == null ? 43 : $fileUpload.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        KeySourceConfigKeystoreType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $passwordCipher = this.getPasswordCipher();
        result = result * 59 + ($passwordCipher == null ? 43 : $passwordCipher.hashCode());
        String $hostURL = this.getHostURL();
        result = result * 59 + ($hostURL == null ? 43 : $hostURL.hashCode());
        String $baseDN = this.getBaseDN();
        result = result * 59 + ($baseDN == null ? 43 : $baseDN.hashCode());
        String $emailAttribute = this.getEmailAttribute();
        result = result * 59 + ($emailAttribute == null ? 43 : $emailAttribute.hashCode());
        String $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        KeySourceConfigAuthDto $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        List $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        return result;
    }

    public KeySourceConfigDto() {
    }

    public KeySourceConfigDto(String uuid, String file, MultipartFile fileUpload, String url, KeySourceConfigKeystoreType type, String password, String passwordCipher, boolean encodeSearchParam, Integer timeout, String hostURL, String baseDN, String emailAttribute, String filter, boolean disableTrustCheck, KeySourceConfigAuthDto auth, List<KeySourceConfigEnvDto> env) {
        this.uuid = uuid;
        this.file = file;
        this.fileUpload = fileUpload;
        this.url = url;
        this.type = type;
        this.password = password;
        this.passwordCipher = passwordCipher;
        this.encodeSearchParam = encodeSearchParam;
        this.timeout = timeout;
        this.hostURL = hostURL;
        this.baseDN = baseDN;
        this.emailAttribute = emailAttribute;
        this.filter = filter;
        this.disableTrustCheck = disableTrustCheck;
        this.auth = auth;
        this.env = env;
    }
}

