/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.keysource.validation;

import java.util.ArrayList;
import java.util.List;
import net.savignano.uptrust.config.features.keysource.model.KeySourceConfigAuthDto;
import net.savignano.uptrust.config.features.keysource.model.KeySourceConfigDto;
import net.savignano.uptrust.config.features.keysource.model.KeySourceDto;
import net.savignano.uptrust.config.features.keysource.validation.KeySourceValidator;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class KeySourceValidator {
    public List<String> validate(KeySourceDto keySource) {
        ArrayList<String> errors = new ArrayList<String>();
        if (keySource == null) {
            errors.add("KEYSOURCE_NULL");
            return errors;
        }
        if (this.isEmpty(keySource.getId())) {
            errors.add("KEYSOURCE_NAME_REQUIRED");
            return errors;
        }
        if (keySource.getCryptography() == null) {
            errors.add("KEYSOURCE_CRYPTOGRAPHY_REQUIRED");
            return errors;
        }
        if (keySource.getType() == null) {
            errors.add("KEYSOURCE_TYPE_REQUIRED");
            return errors;
        }
        if (keySource.getType() == KeySourceDto.KeySourceType.keystore && keySource.getConfidentiality() == null) {
            errors.add("KEYSOURCE_CONFIDENTIALITY_REQUIRED");
            return errors;
        }
        if (keySource.getConfig() == null) {
            errors.add("KEYSOURCE_CONFIG_REQUIRED");
            return errors;
        }
        this.validateConfig(keySource, errors);
        return errors;
    }

    private void validateConfig(KeySourceDto keySource, List<String> errors) {
        KeySourceConfigDto config = keySource.getConfig();
        KeySourceDto.KeySourceType type = keySource.getType();
        KeySourceDto.KeySourceCryptography crypto = keySource.getCryptography();
        KeySourceDto.KeySourceConfidentiality conf = keySource.getConfidentiality();
        switch (1.$SwitchMap$net$savignano$uptrust$config$features$keysource$model$KeySourceDto$KeySourceType[type.ordinal()]) {
            case 1: {
                this.validateKeystoreConfig(config, crypto, conf, errors);
                break;
            }
            case 2: {
                this.validateKeyserverConfig(config, crypto, conf, errors);
                break;
            }
            case 3: {
                this.validateKeyboxConfig(config, crypto, conf, errors);
                break;
            }
            case 4: {
                this.validateLdapConfig(config, crypto, conf, errors);
                break;
            }
            case 5: {
                this.validateGlobalDirectoryConfig(config, crypto, conf, errors);
            }
        }
    }

    private void validateKeystoreConfig(KeySourceConfigDto config, KeySourceDto.KeySourceCryptography crypto, KeySourceDto.KeySourceConfidentiality conf, List<String> errors) {
        if (this.isEmpty(config.getFile()) && this.isEmpty(config.getFileUpload()) && this.isEmpty(config.getUrl())) {
            errors.add("KEYSOURCE_FILE_OR_URL_REQUIRED");
        }
        if (!(this.isEmpty(config.getUrl()) || this.isEmpty(config.getFile()) && this.isEmpty(config.getFileUpload()))) {
            errors.add("Only one of url or file/fileUpload can be provided for keystore type");
        }
        if (crypto == KeySourceDto.KeySourceCryptography.SMIME && config.getType() == null) {
            errors.add("KEYSOURCE_KEYSTORE_TYPE_REQUIRED");
        }
        if (conf == KeySourceDto.KeySourceConfidentiality.PRIVATE && this.isEmpty(config.getPassword())) {
            errors.add("KEYSOURCE_PASSWORD_REQUIRED");
        }
    }

    private void validateKeyserverConfig(KeySourceConfigDto config, KeySourceDto.KeySourceCryptography crypto, KeySourceDto.KeySourceConfidentiality conf, List<String> errors) {
        if (crypto == KeySourceDto.KeySourceCryptography.PGP && this.isEmpty(config.getUrl())) {
            errors.add("KEYSOURCE_URL_REQUIRED");
        }
        if (crypto == KeySourceDto.KeySourceCryptography.SMIME) {
            errors.add("SMIME keyserver is not supported");
        }
    }

    private void validateKeyboxConfig(KeySourceConfigDto config, KeySourceDto.KeySourceCryptography crypto, KeySourceDto.KeySourceConfidentiality conf, List<String> errors) {
        if ((crypto == KeySourceDto.KeySourceCryptography.PGP || crypto == KeySourceDto.KeySourceCryptography.SMIME) && conf == KeySourceDto.KeySourceConfidentiality.PUBLIC && this.isEmpty(config.getFile()) && this.isEmpty(config.getFileUpload()) && this.isEmpty(config.getUrl())) {
            errors.add("KEYSOURCE_FILE_OR_URL_REQUIRED");
        }
    }

    private void validateLdapConfig(KeySourceConfigDto config, KeySourceDto.KeySourceCryptography crypto, KeySourceDto.KeySourceConfidentiality conf, List<String> errors) {
        if (conf == KeySourceDto.KeySourceConfidentiality.PUBLIC) {
            if (this.isEmpty(config.getHostURL())) {
                errors.add("KEYSOURCE_HOST_URL_REQUIRED");
            }
            if (this.isEmpty(config.getBaseDN())) {
                errors.add("KEYSOURCE_BASE_DN_REQUIRED");
            }
            if (this.isEmpty(config.getEmailAttribute())) {
                errors.add("KEYSOURCE_EMAIL_ATTRIBUTE_REQUIRED");
            }
            this.validateAuth(config.getAuth(), "LDAP", errors);
        }
    }

    private void validateGlobalDirectoryConfig(KeySourceConfigDto config, KeySourceDto.KeySourceCryptography crypto, KeySourceDto.KeySourceConfidentiality conf, List<String> errors) {
        if (crypto == KeySourceDto.KeySourceCryptography.SMIME) {
            errors.add("SMIME Global Directory is not supported");
        }
        if (conf == KeySourceDto.KeySourceConfidentiality.PUBLIC) {
            if (this.isEmpty(config.getHostURL())) {
                errors.add("KEYSOURCE_HOST_URL_REQUIRED");
            }
            this.validateAuth(config.getAuth(), "Global Directory", errors);
        }
    }

    private void validateAuth(KeySourceConfigAuthDto auth, String sourceType, List<String> errors) {
        if (auth == null) {
            errors.add("KEYSOURCE_AUTH_REQUIRED");
            return;
        }
        if (auth.getType() == KeySourceConfigAuthDto.AuthType.simple) {
            if (this.isEmpty(auth.getUser())) {
                errors.add("KEYSOURCE_USER_REQUIRED");
            }
            if (this.isEmpty(auth.getPassword())) {
                errors.add("KEYSOURCE_PASSWORD_REQUIRED");
            }
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    private boolean isEmpty(MultipartFile file) {
        return file == null || file.isEmpty();
    }
}

