/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.license.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerService;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerStatus;
import net.savignano.uptrust.config.features.general.model.LicenseDto;
import net.savignano.uptrust.config.features.general.model.UptrustDto;
import net.savignano.uptrust.config.features.license.model.DecodedLicenseDto;
import net.savignano.uptrust.config.features.license.model.LicenseDataDto;
import net.savignano.uptrust.config.features.license.service.LicenseDecoderService;
import net.savignano.uptrust.config.infrastructure.persistence.UptrustRepository;
import net.savignano.uptrust.config.shared.exception.ConfigurationNotFoundException;
import net.savignano.uptrust.config.shared.exception.LicenseInvalidException;
import net.savignano.uptrust.config.shared.exception.LicenseNotConfiguredException;
import net.savignano.uptrust.config.shared.exception.LicenseNotProvidedException;
import net.savignano.uptrust.config.shared.model.ApiResponse;
import net.savignano.uptrust.config.shared.service.ConfigStateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/uptrust/license"})
@Tag(name="License", description="License management endpoints")
public class LicenseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseController.class);
    private final UptrustRepository uptrustRepository;
    private final ConfigStateService configStateService;
    private final LicenseDecoderService licenseDecoderService;
    private final UptrustServerService uptrustServerService;

    public LicenseController(UptrustRepository uptrustRepository, ConfigStateService configStateService, LicenseDecoderService licenseDecoderService, UptrustServerService uptrustServerService) {
        this.uptrustRepository = uptrustRepository;
        this.configStateService = configStateService;
        this.licenseDecoderService = licenseDecoderService;
        this.uptrustServerService = uptrustServerService;
    }

    @GetMapping
    @Operation(summary="Get current license configuration with decoded information")
    public ResponseEntity<ApiResponse<LicenseDataDto>> getCurrentLicense() {
        DecodedLicenseDto decodedLicense;
        Optional uptrustConfig = this.uptrustRepository.findTopByOrderByUuidAsc();
        if (uptrustConfig.isEmpty() || ((UptrustDto)uptrustConfig.get()).getLicense() == null) {
            throw new LicenseNotConfiguredException();
        }
        LicenseDto rawLicense = ((UptrustDto)uptrustConfig.get()).getLicense();
        if (rawLicense.getLicenseRaw() == null || rawLicense.getLicenseRaw().trim().isEmpty()) {
            throw new LicenseNotConfiguredException();
        }
        try {
            decodedLicense = this.licenseDecoderService.decodeLicense(rawLicense.getLicenseRaw());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to decode license: {}", (Object)e.getMessage());
            throw new LicenseInvalidException("Failed to decode license", (Throwable)e);
        }
        LicenseDataDto response = LicenseDataDto.of((LicenseDto)rawLicense, (DecodedLicenseDto)decodedLicense);
        return ResponseEntity.ok((Object)ApiResponse.success((Object)response, (boolean)this.configStateService.hasUnappliedChanges(), (UptrustServerStatus)this.uptrustServerService.getServerStatus()));
    }

    @PutMapping
    @Operation(summary="Update license configuration")
    public ResponseEntity<ApiResponse<LicenseDataDto>> updateLicense(@RequestBody LicenseDataDto licenseRequestDto) {
        DecodedLicenseDto decodedLicense;
        LicenseDto licenseDto = licenseRequestDto.getRawLicense();
        if (licenseDto == null || licenseDto.getLicenseRaw() == null || licenseDto.getLicenseRaw().trim().isEmpty()) {
            throw new LicenseNotProvidedException();
        }
        UptrustDto uptrustConfig = (UptrustDto)this.uptrustRepository.findTopByOrderByUuidAsc().orElseThrow(() -> new ConfigurationNotFoundException("Cannot update license - Uptrust configuration not found"));
        if (!this.licenseDecoderService.isValidLicenseFormat(licenseDto.getLicenseRaw())) {
            throw new LicenseInvalidException("Invalid license format");
        }
        LicenseDto license = uptrustConfig.getLicense();
        if (license == null) {
            license = new LicenseDto();
            uptrustConfig.setLicense(license);
        }
        license.setLicenseRaw(licenseDto.getLicenseRaw());
        license.setLicenseFormat(licenseDto.getLicenseFormat() != null ? licenseDto.getLicenseFormat() : "BASE64");
        this.uptrustRepository.save((Object)uptrustConfig);
        this.configStateService.markUnappliedChanges();
        try {
            decodedLicense = this.licenseDecoderService.decodeLicense(license.getLicenseRaw());
        }
        catch (Exception e) {
            LOGGER.warn("License saved but has validation issues: {}", (Object)e.getMessage());
            decodedLicense = DecodedLicenseDto.builder().build();
        }
        LicenseDataDto response = LicenseDataDto.of((LicenseDto)license, (DecodedLicenseDto)decodedLicense);
        return ResponseEntity.ok((Object)ApiResponse.success((Object)response, (boolean)true));
    }
}

