/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.license.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Date;
import javax0.license3j.License;
import javax0.license3j.io.IOFormat;
import javax0.license3j.io.LicenseReader;
import net.savignano.uptrust.config.features.license.model.DecodedLicenseDto;
import net.savignano.uptrust.config.features.license.service.LicenseValidationKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LicenseDecoderService {
    private static final Logger logger = LoggerFactory.getLogger(LicenseDecoderService.class);

    public DecodedLicenseDto decodeLicense(String base64License) {
        if (base64License == null || base64License.trim().isEmpty()) {
            logger.warn("Empty or null license data provided");
            throw new RuntimeException("License data is empty or null");
        }
        try {
            License license;
            byte[] licenseBytes = Base64.getDecoder().decode(base64License);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(licenseBytes);
            try (LicenseReader reader = new LicenseReader((InputStream)inputStream);){
                license = reader.read(IOFormat.BINARY);
            }
            logger.debug("Successfully parsed license3j license data");
            return this.extractLicenseInfo(license);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Error decoding license3j data", (Throwable)e);
            throw new RuntimeException("Failed to decode license data: " + e.getMessage(), e);
        }
    }

    private DecodedLicenseDto extractLicenseInfo(License license) {
        try {
            boolean isSignatureValid = false;
            try {
                isSignatureValid = license.isOK(LicenseValidationKey.KEY);
                logger.debug("License signature validation result: {}", (Object)isSignatureValid);
            }
            catch (Exception e) {
                logger.warn("Failed to validate license signature", (Throwable)e);
                throw new RuntimeException("License signature validation failed", e);
            }
            if (!isSignatureValid) {
                throw new RuntimeException("License signature is invalid");
            }
            String owner = null;
            String ownerCity = null;
            String ownerZip = null;
            String ownerCountry = null;
            String licenseType = null;
            String userTier = null;
            String licenseId = null;
            LocalDateTime expiryDateTime = null;
            try {
                owner = license.get("owner").getString();
            }
            catch (Exception e) {
                logger.debug("No owner field found in license");
            }
            try {
                ownerCity = license.get("ownerCity").getString();
            }
            catch (Exception e) {
                logger.debug("No ownerCity field found in license");
            }
            try {
                ownerZip = license.get("ownerZip").getString();
            }
            catch (Exception e) {
                logger.debug("No ownerZip field found in license");
            }
            try {
                ownerCountry = license.get("ownerCountry").getString();
            }
            catch (Exception e) {
                logger.debug("No ownerCountry field found in license");
            }
            try {
                licenseType = license.get("licenseType").getString();
            }
            catch (Exception e) {
                logger.debug("No licenseType field found in license");
            }
            try {
                try {
                    userTier = String.valueOf(license.get("userTier").getLong());
                }
                catch (Exception longException) {
                    userTier = license.get("userTier").getString();
                }
            }
            catch (Exception e) {
                logger.debug("No userTier field found in license");
            }
            try {
                try {
                    licenseId = license.get("licenseId").getUUID().toString();
                }
                catch (Exception uuidException) {
                    licenseId = license.get("licenseId").getString();
                }
            }
            catch (Exception e) {
                logger.debug("No licenseId field found in license");
            }
            try {
                Date expiryDate = license.get("expiryDate").getDate();
                expiryDateTime = LocalDateTime.ofInstant(expiryDate.toInstant(), ZoneId.systemDefault());
            }
            catch (Exception e) {
                logger.debug("No expiry date field found in license");
            }
            if (expiryDateTime != null && expiryDateTime.isBefore(LocalDateTime.now())) {
                throw new RuntimeException("License is expired");
            }
            String licensedTo = this.formatLicensedTo(owner, ownerCity, ownerZip, ownerCountry);
            String licensedFor = this.formatLicensedFor(licenseType, userTier);
            String validUntil = this.formatValidUntil(expiryDateTime);
            DecodedLicenseDto result = DecodedLicenseDto.builder().licensed_to(licensedTo).licensed_for(licensedFor).valid_until(validUntil).licenseId(licenseId).build();
            logger.info("Successfully parsed and validated license for owner: {}", (Object)owner);
            return result;
        }
        catch (Exception e) {
            logger.error("Error extracting license information: {}", (Object)e.getMessage());
            throw new RuntimeException("License validation failed: " + e.getMessage(), e);
        }
    }

    private String formatLicensedTo(String owner, String ownerCity, String ownerZip, String ownerCountry) {
        if (owner == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(owner);
        boolean hasLocation = false;
        if (ownerCity != null || ownerZip != null || ownerCountry != null) {
            result.append(", ");
            if (ownerCity != null) {
                result.append(ownerCity);
                hasLocation = true;
            }
            if (ownerZip != null) {
                if (hasLocation) {
                    result.append(" ");
                }
                result.append(ownerZip);
                hasLocation = true;
            }
            if (ownerCountry != null) {
                if (hasLocation) {
                    result.append(", ");
                }
                result.append(ownerCountry);
            }
        }
        return result.toString();
    }

    private String formatLicensedFor(String licenseType, String userTier) {
        if (licenseType == null && userTier == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (licenseType != null) {
            result.append(licenseType).append(" use");
        }
        if (userTier != null) {
            if (licenseType != null) {
                result.append(" with ");
            }
            result.append(userTier).append(" users");
        }
        return result.toString();
    }

    private String formatValidUntil(LocalDateTime expiryDateTime) {
        if (expiryDateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return expiryDateTime.format(formatter);
    }

    public boolean isValidLicenseFormat(String base64License) {
        if (base64License == null || base64License.trim().isEmpty()) {
            return false;
        }
        try {
            License license;
            byte[] licenseBytes = Base64.getDecoder().decode(base64License);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(licenseBytes);
            try (LicenseReader reader = new LicenseReader((InputStream)inputStream);){
                license = reader.read(IOFormat.BINARY);
            }
            boolean isSignatureValid = license.isOK(LicenseValidationKey.KEY);
            logger.debug("License format validation - signature valid: {}", (Object)isSignatureValid);
            return isSignatureValid;
        }
        catch (Exception e) {
            logger.debug("License format validation failed: {}", (Object)e.getMessage());
            return false;
        }
    }
}

