/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.smtpimap.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerService;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerStatus;
import net.savignano.uptrust.config.features.smtpimap.model.SmtpImapConfigDto;
import net.savignano.uptrust.config.features.smtpimap.service.SmtpImapService;
import net.savignano.uptrust.config.shared.model.ApiResponse;
import net.savignano.uptrust.config.shared.service.ConfigStateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/uptrust/smtp-imap-config"})
@Tag(name="SMTP/IMAP Configuration", description="SMTP and IMAP server configuration management endpoints")
public class SmtpImapController {
    private final SmtpImapService smtpImapService;
    private final ConfigStateService configStateService;
    private final UptrustServerService uptrustServerService;

    @Autowired
    public SmtpImapController(SmtpImapService smtpImapService, ConfigStateService configStateService, UptrustServerService uptrustServerService) {
        this.smtpImapService = smtpImapService;
        this.configStateService = configStateService;
        this.uptrustServerService = uptrustServerService;
    }

    @GetMapping
    @Operation(summary="Get SMTP/IMAP configuration", description="Retrieves the current SMTP and IMAP server configuration including host, port, and TLS settings for both protocols.")
    public ResponseEntity<ApiResponse<SmtpImapConfigDto>> getSmtpImapConfig() {
        SmtpImapConfigDto config = this.smtpImapService.getSmtpImapConfig();
        return ResponseEntity.ok((Object)ApiResponse.success((Object)config, (boolean)this.configStateService.hasUnappliedChanges(), (UptrustServerStatus)this.uptrustServerService.getServerStatus()));
    }

    @PutMapping
    @Operation(summary="Update SMTP/IMAP configuration", description="Updates the SMTP and IMAP server configuration with new host, port, and TLS settings for both protocols.")
    public ResponseEntity<ApiResponse<SmtpImapConfigDto>> updateSmtpImapConfig(@Parameter(description="Updated SMTP and IMAP configuration data", required=true) @RequestBody SmtpImapConfigDto smtpImapConfig) {
        SmtpImapConfigDto updatedConfig = this.smtpImapService.updateSmtpImapConfig(smtpImapConfig);
        this.configStateService.markUnappliedChanges();
        return ResponseEntity.ok((Object)ApiResponse.success((Object)updatedConfig, (boolean)true));
    }
}

