/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.smtpimap.service;

import java.util.List;
import java.util.regex.Pattern;
import net.savignano.uptrust.config.features.smtpimap.model.SmtpImapConfigDto;
import net.savignano.uptrust.config.features.smtpimap.repository.SmtpImapConfigRepository;
import net.savignano.uptrust.config.features.smtpimap.validation.SmtpImapValidator;
import net.savignano.uptrust.config.infrastructure.storage.FileStorageService;
import net.savignano.uptrust.config.shared.exception.ConfigurationNotFoundException;
import net.savignano.uptrust.config.shared.exception.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmtpImapService {
    private final SmtpImapConfigRepository smtpImapConfigRepository;
    private final FileStorageService fileStorageService;
    private final SmtpImapValidator smtpImapValidator;
    @Value(value="${uptrust.config.path}")
    private String configPath;

    @Autowired
    public SmtpImapService(SmtpImapConfigRepository smtpImapConfigRepository, FileStorageService fileStorageService, SmtpImapValidator smtpImapValidator) {
        this.smtpImapConfigRepository = smtpImapConfigRepository;
        this.fileStorageService = fileStorageService;
        this.smtpImapValidator = smtpImapValidator;
    }

    public SmtpImapConfigDto getSmtpImapConfig() {
        return (SmtpImapConfigDto)this.smtpImapConfigRepository.findTopByOrderByIdAsc().orElseThrow(() -> new ConfigurationNotFoundException("SMTP/IMAP configuration not found"));
    }

    public SmtpImapConfigDto updateSmtpImapConfig(SmtpImapConfigDto updatedConfig) {
        List validationErrors = this.smtpImapValidator.validate(updatedConfig);
        if (!validationErrors.isEmpty()) {
            throw new ValidationException("SMTP/IMAP configuration", validationErrors);
        }
        SmtpImapConfigDto config = (SmtpImapConfigDto)this.smtpImapConfigRepository.findTopByOrderByIdAsc().orElseThrow(() -> new ConfigurationNotFoundException("Cannot update SMTP/IMAP configuration - configuration not found"));
        config.setSmtpHost(updatedConfig.getSmtpHost());
        config.setSmtpPort(updatedConfig.getSmtpPort());
        config.setSmtpTls(updatedConfig.getSmtpTls());
        config.setImapHost(updatedConfig.getImapHost());
        config.setImapPort(updatedConfig.getImapPort());
        config.setImapTls(updatedConfig.getImapTls());
        String updatedSmtpXmlContent = this.updateXmlContentWithNewValues(config.getSmtpXmlContent(), config.getSmtpHost(), config.getSmtpPort(), config.getSmtpTls());
        String updatedImapXmlContent = this.updateXmlContentWithNewValues(config.getImapXmlContent(), config.getImapHost(), config.getImapPort(), config.getImapTls());
        config.setSmtpXmlContent(updatedSmtpXmlContent);
        config.setImapXmlContent(updatedImapXmlContent);
        return (SmtpImapConfigDto)this.smtpImapConfigRepository.save((Object)config);
    }

    private String updateXmlContentWithNewValues(String xmlContent, String newHost, String newPort, String newTls) {
        String updatedContent = xmlContent;
        if (newHost != null) {
            Pattern hostPattern = Pattern.compile("(<proxyFor>.*?<host>)[^<]*(</host>.*?</proxyFor>)", 34);
            updatedContent = hostPattern.matcher(updatedContent).replaceAll("$1" + newHost + "$2");
        }
        if (newPort != null) {
            Pattern portPattern = Pattern.compile("(<proxyFor>.*?<port>)[^<]*(</port>.*?</proxyFor>)", 34);
            updatedContent = portPattern.matcher(updatedContent).replaceAll("$1" + newPort + "$2");
        }
        if (newTls != null) {
            Pattern tlsPattern = Pattern.compile("(<proxyFor>.*?<tls>)[^<]*(</tls>.*?</proxyFor>)", 34);
            updatedContent = tlsPattern.matcher(updatedContent).replaceAll("$1" + newTls + "$2");
        }
        return updatedContent;
    }
}

