/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.features.smtpimap.validation;

import java.util.ArrayList;
import java.util.List;
import net.savignano.uptrust.config.features.smtpimap.model.SmtpImapConfigDto;
import org.springframework.stereotype.Component;

@Component
public class SmtpImapValidator {
    public List<String> validate(SmtpImapConfigDto config) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config == null) {
            errors.add("SMTP_IMAP_CONFIG_NULL");
            return errors;
        }
        if (this.isEmpty(config.getSmtpHost())) {
            errors.add("SMTP_HOST_REQUIRED");
        }
        if (this.isEmpty(config.getSmtpPort())) {
            errors.add("SMTP_PORT_REQUIRED");
        }
        if (this.isEmpty(config.getSmtpTls())) {
            errors.add("SMTP_TLS_REQUIRED");
        }
        if (this.isEmpty(config.getImapHost())) {
            errors.add("IMAP_HOST_REQUIRED");
        }
        if (this.isEmpty(config.getImapPort())) {
            errors.add("IMAP_PORT_REQUIRED");
        }
        if (this.isEmpty(config.getImapTls())) {
            errors.add("IMAP_TLS_REQUIRED");
        }
        return errors;
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }
}

