/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.infrastructure.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerService;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerStatus;
import net.savignano.uptrust.config.infrastructure.logging.LogParser;
import net.savignano.uptrust.config.infrastructure.logging.LogService;
import net.savignano.uptrust.config.infrastructure.logging.StructuredLogEntry;
import net.savignano.uptrust.config.shared.model.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/logs"})
public class LogController {
    private final LogService logService;
    private final LogParser logParser;
    private final UptrustServerService uptrustServerService;

    @Autowired
    public LogController(LogService logService, LogParser logParser, UptrustServerService uptrustServerService) {
        this.logService = logService;
        this.logParser = logParser;
        this.uptrustServerService = uptrustServerService;
    }

    @GetMapping
    public ResponseEntity<ApiResponse<List<StructuredLogEntry>>> getLogs() {
        List logs = this.logService.getRecentLogs();
        List structuredLogs = this.logParser.parseLogEntries(logs);
        return ResponseEntity.ok((Object)ApiResponse.success((Object)structuredLogs, (UptrustServerStatus)this.uptrustServerService.getServerStatus()));
    }

    @GetMapping(value={"/download"})
    public ResponseEntity<InputStreamResource> downloadLogs() throws IOException {
        try {
            InputStream logFileStream = this.logService.getLogFileStream();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=uptrust.log");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.TEXT_PLAIN).body((Object)new InputStreamResource(logFileStream));
        }
        catch (IOException e) {
            return ResponseEntity.notFound().build();
        }
    }
}

