/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.infrastructure.logging;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.savignano.uptrust.config.infrastructure.logging.LogEntry;
import net.savignano.uptrust.config.infrastructure.logging.StructuredLogEntry;
import org.springframework.stereotype.Component;

@Component
public class LogParser {
    private static final Pattern LOG_PATTERN = Pattern.compile("(\\d{2}:\\d{2}:\\d{2}\\.\\d{3})\\s+\\[(\\w+)\\s*\\]\\s+([^-]+)-\\s*(.*)");

    public StructuredLogEntry parseLogMessage(String logMessage) {
        if (logMessage == null || logMessage.isEmpty()) {
            return StructuredLogEntry.unparsed((String)"");
        }
        Matcher matcher = LOG_PATTERN.matcher(logMessage);
        if (matcher.find()) {
            String timestamp = matcher.group(1);
            String level = matcher.group(2).trim();
            String logger = matcher.group(3).trim();
            String content = matcher.group(4);
            return StructuredLogEntry.parsed((String)timestamp, (String)level, (String)logger, (String)content, (String)logMessage);
        }
        return StructuredLogEntry.unparsed((String)logMessage);
    }

    public List<StructuredLogEntry> parseLogMessages(List<String> logMessages) {
        if (logMessages == null) {
            return List.of();
        }
        return logMessages.stream().map(arg_0 -> this.parseLogMessage(arg_0)).collect(Collectors.toList());
    }

    public List<StructuredLogEntry> parseLogEntries(List<LogEntry> logEntries) {
        if (logEntries == null) {
            return List.of();
        }
        return logEntries.stream().map(entry -> this.parseLogMessage(entry.getMessage())).collect(Collectors.toList());
    }
}

