/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.infrastructure.logging;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.savignano.uptrust.config.infrastructure.logging.LogEntry;
import net.savignano.uptrust.config.infrastructure.logging.LogService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LogService {
    private static final int RECENT_LOG_COUNT = 1000;
    private static final int ERROR_LOG_CACHE_SIZE = 100;
    private static final int WARNING_LOG_CACHE_SIZE = 100;
    private static final DateTimeFormatter LOG_TIMESTAMP_PATTERN = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private static final String LOG_FILE_NAME = "uptrust.log";
    @Value(value="${uptrust.log.dir}")
    private String logDirectory;
    private final List<LogEntry> recentLogs = Collections.synchronizedList(new ArrayList());
    private final List<LogEntry> errorLogs = Collections.synchronizedList(new ArrayList());
    private final List<LogEntry> warningLogs = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLog(String message) {
        LogEntry entry = new LogEntry(LocalDateTime.now(), message);
        LogLevel level = this.detectLogLevel(message);
        List list = this.recentLogs;
        synchronized (list) {
            if (this.recentLogs.size() >= 1000) {
                this.recentLogs.remove(0);
            }
            this.recentLogs.add(entry);
        }
        if (level == LogLevel.ERROR) {
            list = this.errorLogs;
            synchronized (list) {
                if (this.errorLogs.size() >= 100) {
                    this.errorLogs.remove(0);
                }
                this.errorLogs.add(entry);
            }
        }
        if (level == LogLevel.WARN) {
            list = this.warningLogs;
            synchronized (list) {
                if (this.warningLogs.size() >= 100) {
                    this.warningLogs.remove(0);
                }
                this.warningLogs.add(entry);
            }
        }
    }

    private LogLevel detectLogLevel(String message) {
        if (message == null) {
            return LogLevel.UNKNOWN;
        }
        if (message.contains("ERROR")) {
            return LogLevel.ERROR;
        }
        if (message.contains("WARN")) {
            return LogLevel.WARN;
        }
        if (message.contains("INFO")) {
            return LogLevel.INFO;
        }
        if (message.contains("DEBUG")) {
            return LogLevel.DEBUG;
        }
        if (message.contains("TRACE")) {
            return LogLevel.TRACE;
        }
        return LogLevel.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getRecentLogs() {
        List list = this.recentLogs;
        synchronized (list) {
            if (!this.recentLogs.isEmpty()) {
                return new ArrayList<LogEntry>(this.recentLogs);
            }
        }
        return this.readRecentLogsFromFile();
    }

    public InputStream getLogFileStream() throws IOException {
        Path logFile = this.getLogFilePath();
        if (!Files.exists(logFile, new LinkOption[0])) {
            throw new FileNotFoundException("Log file not found: " + String.valueOf(logFile));
        }
        return Files.newInputStream(logFile, new OpenOption[0]);
    }

    private List<LogEntry> readRecentLogsFromFile() {
        try {
            Path logFile = this.getLogFilePath();
            if (!Files.exists(logFile, new LinkOption[0])) {
                return Collections.emptyList();
            }
            List<String> lines = Files.readAllLines(logFile);
            if (lines.isEmpty()) {
                return Collections.emptyList();
            }
            return lines.stream().skip(Math.max(0, lines.size() - 1000)).map(arg_0 -> this.parseLogLine(arg_0)).filter(entry -> entry != null).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private LogEntry parseLogLine(String line) {
        try {
            String timestampStr = line.substring(0, 12);
            LocalDateTime timestamp = LocalDateTime.now().withHour(Integer.parseInt(timestampStr.substring(0, 2))).withMinute(Integer.parseInt(timestampStr.substring(3, 5))).withSecond(Integer.parseInt(timestampStr.substring(6, 8))).withNano(Integer.parseInt(timestampStr.substring(9)) * 1000000);
            return new LogEntry(timestamp, line);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Path getLogFilePath() {
        return Paths.get(this.logDirectory, LOG_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getErrorLogsAfterTimestamp(LocalDateTime since) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        List list = this.errorLogs;
        synchronized (list) {
            for (LogEntry entry : this.errorLogs) {
                if (!entry.getTimestamp().isAfter(since)) continue;
                result.add(entry);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getWarningLogsAfterTimestamp(LocalDateTime since) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        List list = this.warningLogs;
        synchronized (list) {
            for (LogEntry entry : this.warningLogs) {
                if (!entry.getTimestamp().isAfter(since)) continue;
                result.add(entry);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getAllErrorLogs() {
        List list = this.errorLogs;
        synchronized (list) {
            return new ArrayList<LogEntry>(this.errorLogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> getAllWarningLogs() {
        List list = this.warningLogs;
        synchronized (list) {
            return new ArrayList<LogEntry>(this.warningLogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearErrorLogs() {
        List list = this.errorLogs;
        synchronized (list) {
            this.errorLogs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarningLogs() {
        List list = this.warningLogs;
        synchronized (list) {
            this.warningLogs.clear();
        }
    }
}

