/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.infrastructure.password;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.uptrust.config.infrastructure.password.ConfigPasswordService;
import net.savignano.uptrust.config.infrastructure.password.PasswordAlgorithm;
import net.savignano.uptrust.config.shared.exception.PasswordEncryptionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ConfigPasswordService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigPasswordService.class);
    private static final Map<String, PasswordAlgorithm> ALGORITHM_MAPPING = new HashMap();
    @Value(value="${password.encryption.key:}")
    private String passwordKey;

    public String encodePassword(char[] plaintext, PasswordAlgorithm algorithm) throws GeneralSecurityException {
        if (plaintext == null) {
            return null;
        }
        if (algorithm == null) {
            return new String(plaintext);
        }
        return switch (1.$SwitchMap$net$savignano$uptrust$config$infrastructure$password$PasswordAlgorithm[algorithm.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new String(plaintext);
            case 2 -> SecurityUtil.encode((char[])plaintext, (String)this.getPasswordKey());
        };
    }

    public char[] decodePasswordToChars(String encrypted, PasswordAlgorithm algorithm) throws GeneralSecurityException {
        if (encrypted == null) {
            return null;
        }
        if (algorithm == null) {
            return encrypted.toCharArray();
        }
        return switch (1.$SwitchMap$net$savignano$uptrust$config$infrastructure$password$PasswordAlgorithm[algorithm.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> encrypted.toCharArray();
            case 2 -> SecurityUtil.decodeCharsBase64Aes((String)encrypted, (String)this.getPasswordKey());
        };
    }

    public String encryptPassword(String plaintext) {
        if (!this.isEncryptionEnabled() || plaintext == null || plaintext.isEmpty()) {
            return plaintext;
        }
        try {
            return this.encodePassword(plaintext.toCharArray(), PasswordAlgorithm.AES_CBC);
        }
        catch (GeneralSecurityException e) {
            logger.error("Failed to encrypt password", (Throwable)e);
            throw new PasswordEncryptionException("Password encryption failed", (Throwable)e);
        }
    }

    public String decryptPassword(String encrypted) {
        if (!this.isEncryptionEnabled() || encrypted == null || encrypted.isEmpty()) {
            return encrypted;
        }
        try {
            char[] decrypted = this.decodePasswordToChars(encrypted, PasswordAlgorithm.AES_CBC);
            return new String(decrypted);
        }
        catch (GeneralSecurityException e) {
            logger.error("Failed to decrypt password", (Throwable)e);
            throw new PasswordEncryptionException("Password decryption failed", (Throwable)e);
        }
    }

    public boolean isEncrypted(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        try {
            if (value.length() > 16 && value.matches("^[A-Za-z0-9+/]*={0,2}$")) {
                Base64.getDecoder().decode(value);
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public String encryptIfChanged(String newPassword, String existingEncryptedPassword) {
        if (newPassword == null || newPassword.trim().isEmpty()) {
            logger.debug("Empty password received, keeping existing encrypted value");
            return existingEncryptedPassword;
        }
        if (newPassword.equals(existingEncryptedPassword)) {
            logger.debug("Password unchanged, keeping existing encrypted value");
            return existingEncryptedPassword;
        }
        logger.debug("New password received from frontend, encrypting");
        return this.encryptPassword(newPassword);
    }

    public String getCipherType() {
        return this.isEncryptionEnabled() ? PasswordAlgorithm.AES_CBC.toString() : null;
    }

    public String getCipherTypeForPassword(String password) {
        if (this.isEncryptionEnabled() && this.isEncrypted(password)) {
            return PasswordAlgorithm.AES_CBC.toString();
        }
        return null;
    }

    public boolean isEncryptionEnabled() {
        return this.passwordKey != null && !this.passwordKey.trim().isEmpty();
    }

    protected String getPasswordKey() {
        return this.passwordKey;
    }

    protected PasswordAlgorithm toAlgorithm(String strAlg) throws NoSuchAlgorithmException {
        PasswordAlgorithm alg = (PasswordAlgorithm)ALGORITHM_MAPPING.get(StringUtils.toRootLowerCase((String)strAlg));
        if (alg != null) {
            return alg;
        }
        throw new NoSuchAlgorithmException("Algorithm \"" + strAlg + "\" is unknown.");
    }

    static {
        for (PasswordAlgorithm alg : PasswordAlgorithm.values()) {
            ALGORITHM_MAPPING.put(StringUtils.toRootLowerCase((String)alg.name()), alg);
            ALGORITHM_MAPPING.put(StringUtils.toRootLowerCase((String)alg.toString()), alg);
        }
        ALGORITHM_MAPPING.put(null, PasswordAlgorithm.NONE);
        ALGORITHM_MAPPING.put("aes-cbc", PasswordAlgorithm.AES_CBC);
    }
}

