/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.infrastructure.storage;

import java.util.List;
import net.savignano.uptrust.config.features.keysource.model.PendingFileDeletion;
import net.savignano.uptrust.config.infrastructure.persistence.PendingFileDeletionRepository;
import net.savignano.uptrust.config.infrastructure.storage.FileStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileCleanupService {
    private static final Logger logger = LoggerFactory.getLogger(FileCleanupService.class);
    private final PendingFileDeletionRepository pendingFileDeletionRepository;
    private final FileStorageService fileStorageService;

    @Autowired
    public FileCleanupService(PendingFileDeletionRepository pendingFileDeletionRepository, FileStorageService fileStorageService) {
        this.pendingFileDeletionRepository = pendingFileDeletionRepository;
        this.fileStorageService = fileStorageService;
    }

    public void cleanupAfterSuccessfulRestart() {
        List pendingDeletions = this.pendingFileDeletionRepository.findAll();
        for (PendingFileDeletion pending : pendingDeletions) {
            try {
                this.fileStorageService.deleteUploadedFile(pending.getFilePath());
                this.pendingFileDeletionRepository.deleteById((Object)pending.getId());
                logger.info("Successfully deleted old file: {}", (Object)pending.getFilePath());
            }
            catch (Exception e) {
                logger.error("Failed to delete file: " + pending.getFilePath(), (Throwable)e);
            }
        }
    }
}

