/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.infrastructure.storage;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileStorageService {
    private static final Logger logger = LoggerFactory.getLogger(FileStorageService.class);
    @Value(value="${uptrust.keysource.upload.path}")
    private String uploadPath;
    private Path fileStorageLocation;

    @PostConstruct
    public void init() {
        this.fileStorageLocation = Paths.get(this.uploadPath, new String[0]).toAbsolutePath().normalize();
        try {
            Files.createDirectories(this.fileStorageLocation, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not create the directory where the uploaded files will be stored.", ex);
        }
    }

    public void saveConfigFile(byte[] content, String fileName, String directory) throws IOException {
        if (content == null || content.length == 0) {
            throw new IllegalArgumentException("Content must not be null or empty");
        }
        Path filePath = Paths.get(directory, fileName);
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        Files.write(filePath, content, new OpenOption[0]);
        logger.info("Config file saved: {}", (Object)filePath);
    }

    public byte[] readConfigFile(String fileName, String directory) throws IOException {
        Path filePath = Paths.get(directory, fileName);
        return Files.readAllBytes(filePath);
    }

    public String storeUploadedFile(MultipartFile file) {
        try {
            String extension;
            if (file.isEmpty()) {
                throw new RuntimeException("Failed to store empty file.");
            }
            String originalFileName = file.getOriginalFilename();
            if (originalFileName == null || originalFileName.isEmpty()) {
                throw new RuntimeException("Original filename cannot be null or empty.");
            }
            String timestamp = String.valueOf(System.currentTimeMillis());
            int dotIndex = originalFileName.lastIndexOf(46);
            String nameWithoutExt = dotIndex > 0 ? originalFileName.substring(0, dotIndex) : originalFileName;
            String newFileName = nameWithoutExt + "_" + timestamp + (extension = dotIndex > 0 ? originalFileName.substring(dotIndex) : "");
            Path targetLocation = this.fileStorageLocation.resolve(newFileName);
            if (Files.exists(targetLocation, new LinkOption[0])) {
                throw new RuntimeException("File already exists: " + originalFileName);
            }
            Files.copy(file.getInputStream(), targetLocation, new CopyOption[0]);
            return targetLocation.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not store file. Please try again!", ex);
        }
    }

    public void deleteUploadedFile(String fileName) {
        try {
            if (fileName != null && !fileName.isEmpty()) {
                Path file = this.fileStorageLocation.resolve(fileName);
                Files.deleteIfExists(file);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not delete file. Please try again!", ex);
        }
    }

    public Path getFileStorageLocation() {
        return this.fileStorageLocation;
    }
}

