/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.infrastructure.xml;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.savignano.uptrust.config.features.general.model.UptrustDto;
import net.savignano.uptrust.config.features.general.model.Views;
import net.savignano.uptrust.config.features.smtpimap.model.SmtpImapConfigDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class XMLMapperService {
    private static final Logger logger = LoggerFactory.getLogger(XMLMapperService.class);

    public UptrustDto getUptrustDtoFromBytes(byte[] bytes) throws StreamReadException, DatabindException, IOException {
        XmlMapper xmlMapper = new XmlMapper();
        UptrustDto uptrustDto = (UptrustDto)xmlMapper.readValue(bytes, UptrustDto.class);
        return uptrustDto;
    }

    public byte[] getBytesFromUptrustDto(UptrustDto uptrustDto) throws IOException {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        xmlMapper.setConfig(xmlMapper.getSerializationConfig().withView(Views.Public.class));
        xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        String xml = xmlMapper.writeValueAsString((Object)uptrustDto);
        return xml.getBytes(StandardCharsets.UTF_8);
    }

    public SmtpImapConfigDto getSmtpImapConfigDtoFromBytes(byte[] bytesSmtp, byte[] bytesImap) throws StreamReadException, DatabindException, IOException {
        String smtpXmlContent = new String(bytesSmtp, StandardCharsets.UTF_8);
        String imapXmlContent = new String(bytesImap, StandardCharsets.UTF_8);
        String smtpHost = this.extractProxyForValueFromXml(smtpXmlContent, "host");
        String smtpPort = this.extractProxyForValueFromXml(smtpXmlContent, "port");
        String smtpTls = this.extractProxyForValueFromXml(smtpXmlContent, "tls");
        String imapHost = this.extractProxyForValueFromXml(imapXmlContent, "host");
        String imapPort = this.extractProxyForValueFromXml(imapXmlContent, "port");
        String imapTls = this.extractProxyForValueFromXml(imapXmlContent, "tls");
        SmtpImapConfigDto config = SmtpImapConfigDto.builder().smtpHost(smtpHost).smtpPort(smtpPort).smtpTls(smtpTls).imapHost(imapHost).imapPort(imapPort).imapTls(imapTls).smtpXmlContent(smtpXmlContent).imapXmlContent(imapXmlContent).build();
        return config;
    }

    private String extractProxyForValueFromXml(String xmlContent, String elementName) {
        Pattern pattern = Pattern.compile("<proxyFor>.*?<" + elementName + ">([^<]*)</" + elementName + ">.*?</proxyFor>", 34);
        Matcher matcher = pattern.matcher(xmlContent);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        logger.warn("No proxyFor.{} found in XML content", (Object)elementName);
        return "";
    }
}

