/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.shared.exception;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.util.Arrays;
import java.util.List;
import net.savignano.uptrust.config.shared.exception.ConfigurationException;
import net.savignano.uptrust.config.shared.exception.ConfigurationNotFoundException;
import net.savignano.uptrust.config.shared.exception.DomainKeyNotFoundException;
import net.savignano.uptrust.config.shared.exception.FileOperationException;
import net.savignano.uptrust.config.shared.exception.KeySourceNotFoundException;
import net.savignano.uptrust.config.shared.exception.LicenseInvalidException;
import net.savignano.uptrust.config.shared.exception.LicenseNotConfiguredException;
import net.savignano.uptrust.config.shared.exception.LicenseNotProvidedException;
import net.savignano.uptrust.config.shared.exception.PasswordEncryptionException;
import net.savignano.uptrust.config.shared.exception.UptrustServerStatusException;
import net.savignano.uptrust.config.shared.exception.ValidationException;
import net.savignano.uptrust.config.shared.model.ApiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<ApiResponse<Void>> handleValidationException(ValidationException e) {
        logger.warn("Validation error: {}", (Object)e.getMessage());
        String errorCode = e.getErrors().isEmpty() ? e.getMessage() : (String)e.getErrors().get(0);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((String)errorCode));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ApiResponse<Void>> handleHttpMessageNotReadableException(HttpMessageNotReadableException e) {
        InvalidFormatException invalidFormatException;
        Class targetType;
        logger.warn("JSON parsing error: {}", (Object)e.getMessage());
        String userMessage = "Invalid request data";
        Throwable throwable = e.getCause();
        if (throwable instanceof InvalidFormatException && (targetType = (invalidFormatException = (InvalidFormatException)throwable).getTargetType()) != null && targetType.isEnum()) {
            String fieldName = this.extractFieldName(invalidFormatException.getPath());
            String invalidValue = String.valueOf(invalidFormatException.getValue());
            String enumValues = String.join((CharSequence)", ", this.getEnumValues(targetType));
            userMessage = "ENUM_VALIDATION_FAILED";
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((String)userMessage));
    }

    @ExceptionHandler(value={IllegalStateException.class})
    public ResponseEntity<ApiResponse<Void>> handleIllegalStateException(IllegalStateException e) {
        logger.warn("Illegal state: {}", (Object)e.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((String)e.getMessage()));
    }

    @ExceptionHandler(value={ConfigurationException.class})
    public ResponseEntity<ApiResponse<Void>> handleConfigurationException(ConfigurationException e) {
        logger.error("Configuration error: {}", (Object)e.getMessage(), (Object)e);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((String)e.getMessage()));
    }

    @ExceptionHandler(value={LicenseInvalidException.class})
    public ResponseEntity<ApiResponse<Void>> handleLicenseInvalidException(LicenseInvalidException e) {
        logger.warn("Invalid license: {}", (Object)e.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((String)"LICENSE_INVALID"));
    }

    @ExceptionHandler(value={LicenseNotProvidedException.class})
    public ResponseEntity<ApiResponse<Void>> handleLicenseNotProvidedException(LicenseNotProvidedException e) {
        logger.warn("License not provided: {}", (Object)e.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((String)"LICENSE_NOT_PROVIDED"));
    }

    @ExceptionHandler(value={LicenseNotConfiguredException.class})
    public ResponseEntity<ApiResponse<Void>> handleLicenseNotConfiguredException(LicenseNotConfiguredException e) {
        logger.warn("License not configured: {}", (Object)e.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((String)"LICENSE_NOT_CONFIGURED"));
    }

    @ExceptionHandler(value={KeySourceNotFoundException.class})
    public ResponseEntity<ApiResponse<Void>> handleKeySourceNotFoundException(KeySourceNotFoundException e) {
        logger.warn("Key source not found: {}", (Object)e.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((String)"KEYSOURCE_NOT_FOUND"));
    }

    @ExceptionHandler(value={ConfigurationNotFoundException.class})
    public ResponseEntity<ApiResponse<Void>> handleConfigurationNotFoundException(ConfigurationNotFoundException e) {
        logger.warn("Configuration not found: {}", (Object)e.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((String)"Configuration not found"));
    }

    @ExceptionHandler(value={DomainKeyNotFoundException.class})
    public ResponseEntity<ApiResponse<Void>> handleDomainKeyNotFoundException(DomainKeyNotFoundException e) {
        logger.warn("Domain key not found: {}", (Object)e.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((String)"DOMAIN_KEY_NOT_FOUND"));
    }

    @ExceptionHandler(value={FileOperationException.class})
    public ResponseEntity<ApiResponse<Void>> handleFileOperationException(FileOperationException e) {
        logger.error("File operation failed: {}", (Object)e.getMessage(), (Object)e);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)ApiResponse.error((String)("File operation failed: " + e.getMessage())));
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ResponseEntity<ApiResponse<Void>> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException e) {
        logger.warn("File upload size limit exceeded: {}", (Object)e.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.PAYLOAD_TOO_LARGE).body((Object)ApiResponse.error((String)"FILE_SIZE_EXCEEDED"));
    }

    @ExceptionHandler(value={PasswordEncryptionException.class})
    public ResponseEntity<ApiResponse<Void>> handlePasswordEncryptionException(PasswordEncryptionException e) {
        logger.error("Password encryption failed: {}", (Object)e.getMessage(), (Object)e);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((String)"Password encryption failed"));
    }

    @ExceptionHandler(value={UptrustServerStatusException.class})
    public ResponseEntity<ApiResponse<Void>> handleUptrustServerStatusException(UptrustServerStatusException e) {
        logger.warn("Uptrust server status error: {} - {}", (Object)e.getStatus(), (Object)e.getReason());
        return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)ApiResponse.error((String)(e.getReason() != null ? e.getReason() : "Server operation failed")));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<ApiResponse<Void>> handleRuntimeException(RuntimeException e) {
        logger.error("Unexpected runtime error: {}", (Object)e.getMessage(), (Object)e);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((String)"An unexpected error occurred"));
    }

    private String extractFieldName(List<JsonMappingException.Reference> path) {
        if (path != null && !path.isEmpty()) {
            JsonMappingException.Reference lastRef = path.get(path.size() - 1);
            return lastRef.getFieldName() != null ? lastRef.getFieldName() : "Field";
        }
        return "Field";
    }

    private String[] getEnumValues(Class<?> enumClass) {
        if (enumClass.isEnum()) {
            return (String[])Arrays.stream(enumClass.getEnumConstants()).map(Object::toString).toArray(String[]::new);
        }
        return new String[0];
    }
}

