/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.shared.model;

import io.swagger.v3.oas.annotations.media.Schema;
import net.savignano.uptrust.config.core.lifecycle.UptrustServerStatus;

/*
 * Exception performing whole class analysis ignored.
 */
@Schema(description="Standard API response wrapper")
public class ApiResponse<T> {
    @Schema(description="The response data payload. Contains the actual response data for successful requests, null for errors.")
    private T data;
    @Schema(description="Error message for failed requests. Null for successful requests.", example="Configuration not found")
    private String error;
    @Schema(description="Response status indicator", allowableValues={"success", "error"}, example="success")
    private String status;
    @Schema(description="Indicates whether there are configuration changes that haven't been applied yet", example="false")
    private boolean hasUnappliedChanges;
    @Schema(description="Current status of the Uptrust server", example="RUNNING")
    private UptrustServerStatus uptrustServerStatus;

    private ApiResponse(T data, String error, String status, boolean hasUnappliedChanges, UptrustServerStatus uptrustServerStatus) {
        this.data = data;
        this.error = error;
        this.status = status;
        this.hasUnappliedChanges = hasUnappliedChanges;
        this.uptrustServerStatus = uptrustServerStatus;
    }

    public static <T> ApiResponse<T> success(T data, boolean hasUnappliedChanges) {
        return new ApiResponse(data, null, "success", hasUnappliedChanges, null);
    }

    public static <T> ApiResponse<T> success(T data, boolean hasUnappliedChanges, UptrustServerStatus uptrustServerStatus) {
        return new ApiResponse(data, null, "success", hasUnappliedChanges, uptrustServerStatus);
    }

    public static <T> ApiResponse<T> success(T data) {
        return ApiResponse.success(data, (boolean)false);
    }

    public static <T> ApiResponse<T> success(T data, UptrustServerStatus uptrustServerStatus) {
        return ApiResponse.success(data, (boolean)false, (UptrustServerStatus)uptrustServerStatus);
    }

    public static <T> ApiResponse<T> error(String error) {
        return new ApiResponse(null, error, "error", false, null);
    }

    public static <T> ApiResponse<T> error(String error, UptrustServerStatus uptrustServerStatus) {
        return new ApiResponse(null, error, "error", false, uptrustServerStatus);
    }

    public static <T> ApiResponse<T> error(String error, T data) {
        return new ApiResponse(data, error, "error", false, null);
    }

    public T getData() {
        return (T)this.data;
    }

    public String getError() {
        return this.error;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean getHasUnappliedChanges() {
        return this.hasUnappliedChanges;
    }

    public UptrustServerStatus getUptrustServerStatus() {
        return this.uptrustServerStatus;
    }
}

