/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.config.shared.service;

import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigStateService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigStateService.class);
    private final AtomicBoolean hasUnappliedChanges = new AtomicBoolean(false);

    public void markUnappliedChanges() {
        boolean wasSet = this.hasUnappliedChanges.compareAndSet(false, true);
        if (wasSet) {
            logger.debug("Marked configuration changes as unapplied");
        }
    }

    public boolean hasUnappliedChanges() {
        return this.hasUnappliedChanges.get();
    }

    public boolean resetUnappliedChanges() {
        boolean wasReset = this.hasUnappliedChanges.compareAndSet(true, false);
        if (wasReset) {
            logger.debug("Reset unapplied configuration changes flag");
        }
        return wasReset;
    }
}

