/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConsistencyAllRetryPolicy
implements RetryPolicy {
    public static final Logger LOGGER = LoggerFactory.getLogger(LogConsistencyAllRetryPolicy.class);

    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        if (cl == ConsistencyLevel.ALL) {
            this.log(statement);
        }
        return DefaultRetryPolicy.INSTANCE.onReadTimeout(statement, cl, requiredResponses, receivedResponses, dataRetrieved, nbRetry);
    }

    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        if (cl == ConsistencyLevel.ALL) {
            this.log(statement);
        }
        return DefaultRetryPolicy.INSTANCE.onWriteTimeout(statement, cl, writeType, requiredAcks, receivedAcks, nbRetry);
    }

    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        if (cl == ConsistencyLevel.ALL) {
            this.log(statement);
        }
        return DefaultRetryPolicy.INSTANCE.onUnavailable(statement, cl, requiredReplica, aliveReplica, nbRetry);
    }

    public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
        if (cl == ConsistencyLevel.ALL) {
            this.log(statement);
        }
        return DefaultRetryPolicy.INSTANCE.onRequestError(statement, cl, e, nbRetry);
    }

    private void log(Statement statement) {
        Optional<String> statementAsString = this.asString(statement);
        statementAsString.ifPresent(string -> LOGGER.warn("Consistency Level ALL used for executing {}", string));
    }

    private Optional<String> asString(Statement statement) {
        if (statement instanceof PreparedStatement) {
            PreparedStatement preparedStatement = (PreparedStatement)statement;
            return Optional.of(preparedStatement.getQueryString());
        }
        if (statement instanceof SimpleStatement) {
            SimpleStatement simpleStatement = (SimpleStatement)statement;
            return Optional.of(simpleStatement.getQueryString());
        }
        return Optional.empty();
    }

    public void init(Cluster cluster) {
    }

    public void close() {
    }
}

