/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.memory;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.History$;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.MapablePublisher;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scala.publisher.package$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005U4A!\u0003\u0006\u0001/!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003B\u0002$\u0001A\u0003%\u0001\u0006C\u0003H\u0001\u0011\u0005\u0003\nC\u0003d\u0001\u0011\u0005C\rC\u0003i\u0001\u0011%\u0011\u000eC\u0003o\u0001\u0011%q\u000eC\u0003r\u0001\u0011%!O\u0001\nJ]6+Wn\u001c:z\u000bZ,g\u000e^*u_J,'BA\u0006\r\u0003\u0019iW-\\8ss*\u0011QBD\u0001\u000bKZ,g\u000e^:u_J,'BA\b\u0011\u00035)g/\u001a8ug>,(oY5oO*\u0011\u0011CE\u0001\u0006U\u0006lWm\u001d\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0001j\u0011\u0001D\u0005\u0003C1\u0011!\"\u0012<f]R\u001cFo\u001c:f\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\t!\"\u0001\u0005ti>\u0014XMU3g+\u0005A\u0003cA\u00153i5\t!F\u0003\u0002,Y\u00051\u0011\r^8nS\u000eT!!\f\u0018\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00020a\u0005!Q\u000f^5m\u0015\u0005\t\u0014\u0001\u00026bm\u0006L!a\r\u0016\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004B!\u000e\u001f@\u0007:\u0011aG\u000f\t\u0003oii\u0011\u0001\u000f\u0006\u0003sY\ta\u0001\u0010:p_Rt\u0014BA\u001e\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0004\u001b\u0006\u0004(BA\u001e\u001b!\t\u0001\u0015)D\u0001\u000f\u0013\t\u0011eBA\u0006BO\u001e\u0014XmZ1uK&#\u0007CA\u0010E\u0013\t)EBA\u0004ISN$xN]=\u0002\u0013M$xN]3SK\u001a\u0004\u0013!C1qa\u0016tG-\u00117m)\tIU\u000bE\u0002K\u001b>k\u0011a\u0013\u0006\u0003\u0019R\tqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u0003\u001d.\u0013\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u0005A\u001bV\"A)\u000b\u0005I\u0003\u0014\u0001\u00027b]\u001eL!\u0001V)\u0003\tY{\u0017\u000e\u001a\u0005\u0006-\u0012\u0001\raV\u0001\u0007KZ,g\u000e^:\u0011\u0007ak\u0006M\u0004\u0002Z7:\u0011qGW\u0005\u00027%\u0011ALG\u0001\ba\u0006\u001c7.Y4f\u0013\tqvL\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\ta&\u0004\u0005\u0002AC&\u0011!M\u0004\u0002\u0006\u000bZ,g\u000e^\u0001\u0015O\u0016$XI^3oiN|e-Q4he\u0016<\u0017\r^3\u0015\u0005\u00154\u0007c\u0001&N\u0007\")q-\u0002a\u0001\u007f\u0005Y\u0011mZ4sK\u001e\fG/Z%e\u0003-!w.\u00119qK:$\u0017\t\u001c7\u0015\u0005)l\u0007CA\rl\u0013\ta'DA\u0004C_>dW-\u00198\t\u000bY3\u0001\u0019A,\u0002\u001d\u001d,G/Q4he\u0016<\u0017\r^3JIR\u0011q\b\u001d\u0005\u0006-\u001e\u0001\raV\u0001\u0017E\u0016dwN\\4t)>\u001c\u0016-\\3BO\u001e\u0014XmZ1uKR\u0019!n\u001d;\t\u000b\u001dD\u0001\u0019A \t\u000bYC\u0001\u0019A,")
public class InMemoryEventStore
implements EventStore {
    private final AtomicReference<Map<AggregateId, History>> storeRef;

    public Publisher<Void> append(Event event) {
        return EventStore.append$((EventStore)this, (Event)event);
    }

    public Publisher<Void> appendAll(Seq<Event> events) {
        return EventStore.appendAll$((EventStore)this, events);
    }

    public Publisher<Void> appendAll(Event ... events) {
        return EventStore.appendAll$((EventStore)this, (Event[])events);
    }

    private AtomicReference<Map<AggregateId, History>> storeRef() {
        return this.storeRef;
    }

    public Publisher<Void> appendAll(Iterable<Event> events) {
        return events.nonEmpty() ? package$.MODULE$.publisherUnit2PublisherVoid((MapablePublisher)SMono$.MODULE$.fromCallable(() -> BoxesRunTime.boxToBoolean((boolean)this.doAppendAll((Iterable<Event>)events))).then()) : SMono$.MODULE$.empty();
    }

    public Publisher<History> getEventsOfAggregate(AggregateId aggregateId) {
        Preconditions.checkNotNull((Object)aggregateId);
        return SMono$.MODULE$.fromCallable(() -> (History)((MapOps)this.storeRef().get()).apply((Object)aggregateId));
    }

    private boolean doAppendAll(Iterable<Event> events) {
        AggregateId aggregateId = this.getAggregateId(events);
        this.storeRef().updateAndGet(store -> {
            History updatedHistory = History$.MODULE$.of((List)((History)store.apply((Object)aggregateId)).getEvents().$plus$plus((IterableOnce)events));
            return (Map)store.updated((Object)aggregateId, (Object)updatedHistory);
        });
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private AggregateId getAggregateId(Iterable<Event> events) {
        void var2_2;
        Preconditions.checkArgument((boolean)events.nonEmpty());
        AggregateId aggregateId = ((Event)events.head()).getAggregateId();
        Preconditions.checkArgument((boolean)this.belongsToSameAggregate(aggregateId, events));
        return var2_2;
    }

    private boolean belongsToSameAggregate(AggregateId aggregateId, Iterable<Event> events) {
        return events.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)InMemoryEventStore.$anonfun$belongsToSameAggregate$1(aggregateId, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$belongsToSameAggregate$1(AggregateId aggregateId$3, Event x$2) {
        return x$2.getAggregateId().equals(aggregateId$3);
    }

    public InMemoryEventStore() {
        EventStore.$init$((EventStore)this);
        this.storeRef = new AtomicReference<Map>(((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).withDefault((Function1 & Serializable)x$1 -> History$.MODULE$.empty()));
    }
}

