/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.smtp.handler;

import java.io.IOException;
import java.util.Optional;
import net.savignano.uptrust.proxy.base.proxy.IProxy;
import net.savignano.uptrust.proxy.base.request.IProxyRequest;
import net.savignano.uptrust.proxy.smtp.proxy.IProxySmtpSession;
import net.savignano.uptrust.proxy.smtp.request.ProxyRequest;
import net.savignano.uptrust.proxy.smtp.response.ProxyResponse;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.CommandHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AProxyHandler
implements CommandHandler<IProxySmtpSession> {
    protected static final SMTPResponse PROXY_SEND_FAILURE_RESPONSE;
    private static final SMTPResponse PROXY_CONNECTION_FAILURE_RESPONSE;
    private static final SMTPResponse MISSING_RESPONSE_RESPONSE;
    private static final SMTPResponse ENFORCE_STARTTLS_RESPONSE;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean ignoreEnforceStartTls;

    public Response onCommand(IProxySmtpSession session, Request request) {
        Optional<LineHandler<IProxySmtpSession>> followup;
        this.log.debug("Proxy request: {}", (Object)request);
        ProxyData data = new ProxyData();
        data.request = ProxyRequest.from(request);
        data.session = session;
        data.proxy = session.getProxy();
        if (data.proxy == null || !data.proxy.isReady()) {
            this.log.error("Not conntected to remote server at \"{}\".", this.getProxyAddress(data.proxy));
            data.response = PROXY_CONNECTION_FAILURE_RESPONSE;
        }
        if (data.session.isStartTLSSupported() && !data.session.isTLSStarted() && data.session.isStartTLSEnforced() && !this.isIgnoreEnforceStartTls()) {
            this.log.debug("Start TLS not yet activated, but is enforced by session configuration.");
            data.response = ENFORCE_STARTTLS_RESPONSE;
        }
        if (data.response == null) {
            try {
                this.doHandle(data);
                this.log.debug("Proxy response: {}", (Object)data.response);
            }
            catch (IOException e) {
                this.log.error("Error communicating with server at \"" + String.valueOf(this.getProxyAddress(data.proxy)) + "\". Error message: " + e.getMessage(), (Throwable)e);
                data.response = PROXY_SEND_FAILURE_RESPONSE;
            }
        }
        if (data.response == null) {
            this.log.debug("Handler {} returned null response. Creating default failure response.", (Object)this.getClass().getSimpleName());
            data.response = MISSING_RESPONSE_RESPONSE;
        }
        if (!data.response.isEndSession() && !data.response.getRetCode().equals("554") && (followup = this.getClientFollowupHandler(data)).isPresent()) {
            data.session.pushLineHandler(followup.get());
        }
        return data.response;
    }

    protected void doHandle(ProxyData data) throws IOException {
        data.response = ((ProxyResponse)data.proxy.send((IProxyRequest)data.request)).toResponse();
    }

    protected Optional<LineHandler<IProxySmtpSession>> getClientFollowupHandler(ProxyData data) {
        return Optional.empty();
    }

    private Object getProxyAddress(IProxy<?, ?> proxy) {
        return proxy == null ? "N/A" : proxy.getAddress();
    }

    protected boolean isIgnoreEnforceStartTls() {
        return this.ignoreEnforceStartTls;
    }

    protected void setIgnoreEnforceStartTls(boolean ignoreEnforceStartTls) {
        this.ignoreEnforceStartTls = ignoreEnforceStartTls;
    }

    static {
        MISSING_RESPONSE_RESPONSE = new SMTPResponse("554", (CharSequence)"Internal server error. Probably permanent, but want to try again anyway.");
        PROXY_SEND_FAILURE_RESPONSE = new SMTPResponse("554", (CharSequence)"Error communicating with server. Terminating session.");
        PROXY_SEND_FAILURE_RESPONSE.setEndSession(true);
        PROXY_CONNECTION_FAILURE_RESPONSE = new SMTPResponse("554", (CharSequence)"Server not ready to receive requests. Terminating session.");
        PROXY_CONNECTION_FAILURE_RESPONSE.setEndSession(true);
        ENFORCE_STARTTLS_RESPONSE = new SMTPResponse("530", (CharSequence)"Must issue a STARTTLS command first");
    }

    public static class ProxyData {
        public IProxy<ProxyRequest, ProxyResponse> proxy;
        public ProxyRequest request;
        public Response response;
        public IProxySmtpSession session;
    }
}

