/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.smtp.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.uptrust.proxy.base.handler.IComplexMailHandler;
import net.savignano.uptrust.proxy.base.proxy.IProxy;
import net.savignano.uptrust.proxy.base.request.IProxyRequest;
import net.savignano.uptrust.proxy.smtp.handler.AProxyHandler;
import net.savignano.uptrust.proxy.smtp.handler.MailProxyHandler;
import net.savignano.uptrust.proxy.smtp.handler.RcptProxyHandler;
import net.savignano.uptrust.proxy.smtp.proxy.IProxySmtpSession;
import net.savignano.uptrust.proxy.smtp.request.ProxyRequest;
import net.savignano.uptrust.proxy.smtp.response.ProxyResponse;
import net.savignano.uptrust.service.EResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;

public class DataProxyHandler
extends AProxyHandler {
    private static final Response NO_RECIPIENT = new SMTPResponse("503", (CharSequence)(DSNStatus.getStatus((int)5, (String)"5.0") + " No recipients specified")).immutable();
    private static final Response NO_SENDER = new SMTPResponse("503", (CharSequence)(DSNStatus.getStatus((int)5, (String)"5.0") + " No sender specified")).immutable();
    private static final Response UNEXPECTED_ARG = new SMTPResponse("500", (CharSequence)(DSNStatus.getStatus((int)5, (String)"5.4") + " Unexpected argument provided with DATA command")).immutable();
    private static final Response DATA_READY = new SMTPResponse("354", (CharSequence)"Ok Send data ending with <CRLF>.<CRLF>").immutable();
    private static final Collection<String> COMMANDS = Collections.singleton("DATA");
    private static final ProtocolSession.AttachmentKey<ByteArrayOutputStream> DATA_PAYLOAD_KEY = ProtocolSession.AttachmentKey.of((String)"dataPayload", ByteArrayOutputStream.class);
    private final Session mailSession;
    private final IComplexMailHandler mailHandler;

    @Inject
    public DataProxyHandler(Session mailSession, @Named(value="smtpOutgoingMailHandler") IComplexMailHandler mailHandler) {
        this.mailSession = mailSession;
        this.mailHandler = mailHandler;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected void doHandle(AProxyHandler.ProxyData data) throws IOException {
        data.response = !StringUtils.isBlank((CharSequence)data.request.getData()) ? UNEXPECTED_ARG : (data.session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).isEmpty() ? NO_SENDER : (data.session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).isEmpty() || ((List)data.session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).get()).isEmpty() ? NO_RECIPIENT : DATA_READY));
    }

    @Override
    protected Optional<LineHandler<IProxySmtpSession>> getClientFollowupHandler(AProxyHandler.ProxyData data) {
        if (!data.response.getRetCode().equals("354")) {
            return Optional.empty();
        }
        data.session.setAttachment(DATA_PAYLOAD_KEY, new ByteArrayOutputStream(4096), ProtocolSession.State.Transaction);
        return Optional.of(this::collectData);
    }

    private Response collectData(IProxySmtpSession session, ByteBuffer buffer) {
        if (this.log.isTraceEnabled()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.addRemainingData(buffer, os);
            buffer.rewind();
            this.log.trace("Mail data received: {}", (Object)os.toString(Constants.ASCII_CHARSET));
        }
        ByteArrayOutputStream payload = (ByteArrayOutputStream)session.getAttachment(DATA_PAYLOAD_KEY, ProtocolSession.State.Transaction).get();
        Response response = null;
        byte b = buffer.get();
        if (b == 46 && buffer.remaining() == 2) {
            SessionData sessionData = new SessionData(session);
            session.popLineHandler();
            session.resetState();
            response = this.processAllData(sessionData);
        } else if (b == 46 && buffer.get() == 46) {
            buffer.rewind();
            buffer.get();
            this.addRemainingData(buffer, payload);
        } else {
            buffer.rewind();
            this.addRemainingData(buffer, payload);
        }
        return response;
    }

    private void addRemainingData(ByteBuffer from, ByteArrayOutputStream to) {
        while (from.hasRemaining()) {
            to.write(from.get());
        }
    }

    private Response processAllData(SessionData data) {
        List<Map<String, Object>> processedMessages;
        this.log.trace("Received full message, preparing to send message.");
        try {
            processedMessages = this.processMessage(data);
        }
        catch (MessagingException e) {
            this.log.error("Could not parse mail data. Error message: " + e.getMessage(), (Throwable)e);
            return new SMTPResponse("451", (CharSequence)"Internal error. Could not parse mail data.");
        }
        this.log.debug("Processed messages: {}", processedMessages);
        if (processedMessages.size() == 1) {
            return this.processSingleMessage((MimeMessage)processedMessages.get(0).get("message"), data);
        }
        return this.processMultiMessage(processedMessages, data);
    }

    private List<Map<String, Object>> processMessage(SessionData data) throws MessagingException {
        this.log.trace("Processing data.");
        MimeMessage msg = new MimeMessage(this.mailSession, (InputStream)new ByteArrayInputStream(data.mailData, 0, data.mailData.length - 2));
        if (this.mailHandler != null) {
            Map<String, List<Address>> context = Collections.singletonMap("relevantAddresses", data.recipients);
            return this.mailHandler.handleMessage(msg, context);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("message", msg);
        result.put("addresses", data.recipients);
        result.put("outcome", EResult.SUCCESS);
        result.put("cryptography", ECryptographyType.NONE);
        return Collections.singletonList(result);
    }

    private Response processSingleMessage(MimeMessage msg, SessionData data) {
        String dataToSend;
        this.log.trace("Processing single message.");
        try {
            dataToSend = this.encodeMessageForSmtp(msg, data.mailData.length * 2);
        }
        catch (IOException | MessagingException e) {
            this.log.error("Could not write mail data. Error message: " + e.getMessage(), e);
            return new SMTPResponse("451", (CharSequence)"Internal error. Could not write mail data.");
        }
        try {
            ProxyResponse response = this.sendMessage(dataToSend, data.proxy);
            return response.toResponse();
        }
        catch (IOException e) {
            this.log.error("Error communicating with server at \"" + String.valueOf(data.proxy.getAddress()) + "\". Error message: " + e.getMessage(), (Throwable)e);
            return PROXY_SEND_FAILURE_RESPONSE;
        }
    }

    private Response processMultiMessage(List<Map<String, Object>> messages, SessionData data) {
        this.log.trace("Processing multe message.");
        try {
            ProxyResponse resetResponse = (ProxyResponse)data.proxy.send((IProxyRequest)new ProxyRequest("RSET", null));
            this.log.debug("Reset response: {}", (Object)resetResponse);
        }
        catch (IOException e) {
            this.log.error("Error communicating with server at \"" + String.valueOf(data.proxy.getAddress()) + "\". Error message: " + e.getMessage(), (Throwable)e);
            return PROXY_SEND_FAILURE_RESPONSE;
        }
        SMTPResponse response = null;
        try {
            for (Map<String, Object> msgData : messages) {
                this.log.debug("Processing message data: {}", msgData);
                MimeMessage msg = (MimeMessage)msgData.get("message");
                List recipients = (List)msgData.get("addresses");
                if (msg == null || recipients == null || recipients.isEmpty()) continue;
                String dataToSend = this.encodeMessageForSmtp(msg, data.mailData.length * 2);
                Optional<Response> mailResponse = this.mailFromCmd(data.from, data.proxy);
                if (mailResponse.isPresent()) {
                    response = mailResponse.get();
                } else {
                    Optional<Response> rcptResponse = this.rcptToCmd(recipients, data.proxy);
                    if (rcptResponse.isPresent()) {
                        response = rcptResponse.get();
                    } else {
                        ProxyResponse proxyResponse = this.sendMessage(dataToSend, data.proxy);
                        response = proxyResponse.toResponse();
                        if (response.getRetCode().equals("250")) continue;
                        response = new SMTPResponse("554", (CharSequence)("Server did not accept DATA command. Response: " + String.valueOf(response)));
                    }
                }
                break;
            }
        }
        catch (MessagingException e) {
            this.log.error("Could not write mail data. Error message: " + e.getMessage(), (Throwable)e);
            response = new SMTPResponse("451", (CharSequence)"Internal error. Could not write mail data.");
        }
        catch (IOException e) {
            this.log.error("Error communicating with server at \"" + String.valueOf(data.proxy.getAddress()) + "\". Error message: " + e.getMessage(), (Throwable)e);
            response = PROXY_SEND_FAILURE_RESPONSE;
        }
        if (response == null) {
            response = new SMTPResponse("554", (CharSequence)"Sending of email has been supressed. Probable cause is that no valid encryption has been available for the recipient(s).");
        }
        return response;
    }

    private String encodeMessageForSmtp(MimeMessage msg, int bufferSize) throws IOException, MessagingException {
        Object dataToSend;
        this.log.trace("Encoding message for Sending.");
        try (ByteArrayOutputStream os = new ByteArrayOutputStream(bufferSize);){
            msg.writeTo((OutputStream)os);
            dataToSend = os.toString(Constants.ASCII_CHARSET);
        }
        dataToSend = ((String)dataToSend).replaceAll("\r\n\\.", "\r\n..");
        dataToSend = (String)dataToSend + "\r\n.\r\n";
        return dataToSend;
    }

    private Optional<Response> mailFromCmd(Address from, IProxy<ProxyRequest, ProxyResponse> proxy) throws IOException {
        ProxyResponse mailResponse = (ProxyResponse)proxy.send((IProxyRequest)new ProxyRequest("MAIL", "FROM \"" + from.toString() + "\""));
        if (!MailProxyHandler.isValidResponse(mailResponse.getResponseCode())) {
            return Optional.of(new SMTPResponse("554", (CharSequence)("Server did not accept MAIL FROM command. Response: " + String.valueOf((Object)mailResponse))));
        }
        return Optional.empty();
    }

    private Optional<Response> rcptToCmd(List<Address> recipients, IProxy<ProxyRequest, ProxyResponse> proxy) throws IOException {
        for (Address recipient : recipients) {
            ProxyResponse rcptResponse = (ProxyResponse)proxy.send((IProxyRequest)new ProxyRequest("RCPT", "TO \"" + String.valueOf(recipient) + "\""));
            if (RcptProxyHandler.isValidResponse(rcptResponse.getResponseCode())) continue;
            return Optional.of(new SMTPResponse("554", (CharSequence)("Server did not accept RCPT TO command. Response: " + String.valueOf((Object)rcptResponse))));
        }
        return Optional.empty();
    }

    private ProxyResponse sendMessage(String data, IProxy<ProxyRequest, ProxyResponse> proxy) throws IOException {
        this.log.trace("Sending data command.");
        ProxyResponse dataResponse = (ProxyResponse)proxy.send((IProxyRequest)new ProxyRequest("DATA", null));
        this.log.debug("Response of DATA command: {}", (Object)dataResponse);
        if (!dataResponse.getResponseCode().equals("354")) {
            return dataResponse;
        }
        this.log.trace("Sending message data.");
        ProxyResponse response = (ProxyResponse)proxy.send((IProxyRequest)new ProxyRequest(data));
        this.log.debug("Proxy response: {}", (Object)response);
        return response;
    }

    private static final class SessionData {
        public final Address from;
        public final List<Address> recipients;
        public final byte[] mailData;
        final IProxy<ProxyRequest, ProxyResponse> proxy;

        public SessionData(IProxySmtpSession session) {
            this.from = this.getFrom(session);
            this.recipients = this.getRecipients(session);
            this.mailData = this.getMailData(session);
            this.proxy = this.getProxy(session);
        }

        private Address getFrom(IProxySmtpSession session) {
            Optional senderAttachment = session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction);
            if (senderAttachment.isEmpty()) {
                throw new RuntimeException("\"" + SMTPSession.SENDER.asString() + "\" has not been filled.");
            }
            MaybeSender maybeSender = (MaybeSender)senderAttachment.get();
            if (maybeSender.isNullSender()) {
                throw new RuntimeException("\"" + SMTPSession.SENDER.asString() + "\" is 'null sender'.");
            }
            Optional address = maybeSender.get().toInternetAddress();
            if (address.isEmpty()) {
                throw new RuntimeException("\"" + SMTPSession.SENDER.asString() + "\" could not be parsed.");
            }
            return (Address)address.get();
        }

        private List<Address> getRecipients(IProxySmtpSession session) {
            Optional rcptAttachment = session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction);
            if (rcptAttachment.isEmpty()) {
                throw new RuntimeException("\"" + SMTPSession.RCPT_LIST.asString() + "\" has not been filled.");
            }
            return ((List)rcptAttachment.get()).stream().flatMap(ma -> ma.toInternetAddress().stream()).collect(Collectors.toUnmodifiableList());
        }

        private byte[] getMailData(IProxySmtpSession session) {
            Optional mailAttachment = session.getAttachment(DATA_PAYLOAD_KEY, ProtocolSession.State.Transaction);
            if (mailAttachment.isEmpty()) {
                throw new RuntimeException("\"" + DATA_PAYLOAD_KEY.asString() + "\" has not been filled.");
            }
            return ((ByteArrayOutputStream)mailAttachment.get()).toByteArray();
        }

        private IProxy<ProxyRequest, ProxyResponse> getProxy(IProxySmtpSession session) {
            return session.getProxy();
        }
    }
}

