/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.smtp.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.savignano.uptrust.proxy.base.request.IProxyRequest;
import net.savignano.uptrust.proxy.smtp.handler.AProxyHandler;
import net.savignano.uptrust.proxy.smtp.response.ProxyResponse;
import org.apache.commons.lang3.StringUtils;

public class EhloProxyHandler
extends AProxyHandler {
    private static final Collection<String> COMMANDS = Collections.singleton("EHLO");
    private static final String EHLO_SUCCESS_CODE = "250";
    private static final String START_TLS_CAPABILITY = "STARTTLS";
    private static final String CHUNKING_CAPABILITY = "CHUNKING";

    public EhloProxyHandler() {
        this.setIgnoreEnforceStartTls(true);
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected void doHandle(AProxyHandler.ProxyData data) throws IOException {
        ProxyResponse response = (ProxyResponse)data.proxy.send((IProxyRequest)data.request);
        if (!response.getResponseCode().equals(EHLO_SUCCESS_CODE)) {
            data.response = response.toResponse();
            return;
        }
        String[] lines = response.getLines();
        lines = this.handleStarttls(lines, data.session.isStartTLSSupported());
        lines = this.handleChunking(lines);
        data.response = new ProxyResponse(lines).toResponse();
    }

    private String[] handleStarttls(String[] lines, boolean supported) {
        return supported ? this.addCapability(lines, START_TLS_CAPABILITY) : this.removeCapability(lines, START_TLS_CAPABILITY);
    }

    private String[] handleChunking(String[] lines) {
        return this.removeCapability(lines, CHUNKING_CAPABILITY);
    }

    private String[] addCapability(String[] lines, String capability) {
        ArrayList<Object> adjustedLines = new ArrayList<Object>(lines.length + 1);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (StringUtils.endsWithIgnoreCase((CharSequence)line, (CharSequence)capability)) {
                return lines;
            }
            adjustedLines.add(line);
        }
        adjustedLines.add(1, ((String)adjustedLines.get(0)).substring(0, 4) + capability);
        if (adjustedLines.size() == 2) {
            Object firstLine = (String)adjustedLines.get(0);
            firstLine = ((String)firstLine).substring(0, 3) + "-" + ((String)firstLine).substring(4);
            adjustedLines.set(0, firstLine);
        }
        return adjustedLines.toArray(new String[adjustedLines.size()]);
    }

    private String[] removeCapability(String[] lines, String capability) {
        ArrayList<Object> adjustedLines = new ArrayList<Object>(lines.length);
        boolean found = false;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (StringUtils.endsWithIgnoreCase((CharSequence)line, (CharSequence)capability)) {
                found = true;
                if (line.charAt(4) != ' ') continue;
                Object lastLine = (String)adjustedLines.get(adjustedLines.size() - 1);
                lastLine = ((String)lastLine).substring(0, 3) + " " + ((String)lastLine).substring(4);
                adjustedLines.set(adjustedLines.size() - 1, lastLine);
                continue;
            }
            adjustedLines.add(line);
        }
        return found ? adjustedLines.toArray(new String[adjustedLines.size()]) : lines;
    }
}

