/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.smtp.handler;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import net.savignano.uptrust.proxy.base.request.IProxyRequest;
import net.savignano.uptrust.proxy.smtp.handler.AProxyHandler;
import net.savignano.uptrust.proxy.smtp.response.ProxyResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;

public class MailProxyHandler
extends AProxyHandler {
    private static final Collection<String> COMMANDS = Collections.singleton("MAIL");

    static boolean isValidResponse(String respCode) {
        return "250".equals(respCode);
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected void doHandle(AProxyHandler.ProxyData data) throws IOException {
        ProxyResponse response = (ProxyResponse)data.proxy.send((IProxyRequest)data.request);
        data.response = response.toResponse();
        if (!MailProxyHandler.isValidResponse(response.getResponseCode())) {
            return;
        }
        MaybeSender address = this.parseAddress(data.request.getData());
        data.session.setAttachment(SMTPSession.SENDER, address, ProtocolSession.State.Transaction);
    }

    private MaybeSender parseAddress(String parse) {
        int routing;
        String str = parse;
        if (StringUtils.startsWithIgnoreCase((CharSequence)str, (CharSequence)"from:")) {
            str = str.substring(5);
        }
        int bracketsOpen = str.indexOf(60);
        int bracketsClosed = str.indexOf(62);
        if (bracketsOpen != -1 && bracketsClosed != -1) {
            str = str.substring(bracketsOpen + 1, bracketsClosed);
        }
        if ((routing = str.indexOf(58)) != -1) {
            str = str.substring(routing + 1);
        }
        return MaybeSender.getMailSender((String)str.strip());
    }
}

