/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.smtp.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.mail.internet.AddressException;
import net.savignano.uptrust.proxy.base.request.IProxyRequest;
import net.savignano.uptrust.proxy.smtp.handler.AProxyHandler;
import net.savignano.uptrust.proxy.smtp.response.ProxyResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.core.MailAddress;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;

public class RcptProxyHandler
extends AProxyHandler {
    private static final Collection<String> COMMANDS = Collections.singleton("RCPT");

    static boolean isValidResponse(String respCode) {
        switch (respCode) {
            case "250": 
            case "251": 
            case "252": {
                return true;
            }
        }
        return false;
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected void doHandle(AProxyHandler.ProxyData data) throws IOException {
        MailAddress address;
        ProxyResponse response = (ProxyResponse)data.proxy.send((IProxyRequest)data.request);
        data.response = response.toResponse();
        if (!RcptProxyHandler.isValidResponse(response.getResponseCode())) {
            return;
        }
        try {
            address = this.parseAddress(data.request.getData());
        }
        catch (AddressException e) {
            throw new IOException("Could not parse email address. Error message: " + e.getMessage(), e);
        }
        List rcptColl = data.session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).orElseGet(ArrayList::new);
        rcptColl.add(address);
        data.session.setAttachment(SMTPSession.RCPT_LIST, rcptColl, ProtocolSession.State.Transaction);
    }

    private MailAddress parseAddress(String parse) throws AddressException {
        int routing;
        String str = parse;
        if (StringUtils.startsWithIgnoreCase((CharSequence)str, (CharSequence)"to:")) {
            str = str.substring(3);
        }
        int bracketsOpen = str.indexOf(60);
        int bracketsClosed = str.indexOf(62);
        if (bracketsOpen != -1 && bracketsClosed != -1) {
            str = str.substring(bracketsOpen + 1, bracketsClosed);
        }
        if ((routing = str.indexOf(58)) != -1) {
            str = str.substring(routing + 1);
        }
        return new MailAddress(str.strip());
    }
}

