/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.smtp.handler;

import java.io.IOException;
import java.net.UnknownHostException;
import net.savignano.uptrust.proxy.base.proxy.IProxy;
import net.savignano.uptrust.proxy.smtp.proxy.IProxySmtpSession;
import net.savignano.uptrust.proxy.smtp.request.ProxyRequest;
import net.savignano.uptrust.proxy.smtp.response.ProxyResponse;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WelcomeProxyHandler
implements ConnectHandler<IProxySmtpSession> {
    private static final Logger LOG = LoggerFactory.getLogger(WelcomeProxyHandler.class);

    public Response onConnect(IProxySmtpSession session) {
        IProxy<ProxyRequest, ProxyResponse> proxy = session.getProxy();
        if (proxy == null) {
            LOG.error("No proxy configured.");
            SMTPResponse response = new SMTPResponse("554", (CharSequence)"Server not correctly configured to receive requests.");
            response.setEndSession(true);
            return response;
        }
        try {
            ProxyResponse welcomeMsg = (ProxyResponse)proxy.connect();
            LOG.debug("Welcome message: {}", (Object)welcomeMsg);
            return welcomeMsg.toResponse();
        }
        catch (UnknownHostException e) {
            LOG.error("Could not connect to \"" + String.valueOf(proxy.getAddress()) + "\". Unknown host. Error message: " + e.getMessage(), (Throwable)e);
            SMTPResponse response = new SMTPResponse("554", (CharSequence)("Unknown host: " + String.valueOf(proxy.getAddress())));
            response.setEndSession(true);
            return response;
        }
        catch (IOException e) {
            LOG.error("Error connecting to \"" + String.valueOf(proxy.getAddress()) + "\". Error message: " + e.getMessage(), (Throwable)e);
            SMTPResponse response = new SMTPResponse("554", (CharSequence)("Connection error to: " + String.valueOf(proxy.getAddress())));
            response.setEndSession(true);
            return response;
        }
    }
}

