/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.uptrust.proxy.smtp.proxy;

import net.savignano.uptrust.proxy.base.proxy.ETransportSecurity;

public class SmtpProxyConfiguration {
    private final String host;
    private final int port;
    private final ETransportSecurity transportSecurity;

    private SmtpProxyConfiguration(String host, int port, ETransportSecurity transportSecurity) {
        this.host = host;
        this.port = port;
        this.transportSecurity = transportSecurity;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ETransportSecurity getTransportSecurity() {
        return this.transportSecurity;
    }

    public static final class SmtpProxyConfigurationBuilder {
        public static final int DEFAULT_SMTP_PORT = 25;
        private String host = "localhost";
        private int port = 25;
        private ETransportSecurity transportSecurity = ETransportSecurity.START_TLS;

        public static SmtpProxyConfigurationBuilder builder() {
            return new SmtpProxyConfigurationBuilder();
        }

        public SmtpProxyConfigurationBuilder host(String host) {
            this.host = host;
            return this;
        }

        public SmtpProxyConfigurationBuilder port(int port) {
            this.port = port;
            return this;
        }

        public SmtpProxyConfigurationBuilder transportSecurity(ETransportSecurity transportSecurity) {
            this.transportSecurity = transportSecurity;
            return this;
        }

        public SmtpProxyConfiguration build() {
            return new SmtpProxyConfiguration(this.host, this.port, this.transportSecurity);
        }
    }
}

