/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;
import org.apache.mailbox.tools.indexer.SingleMailboxReindexingTaskDTO;

public class SingleMailboxReindexingTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"mailbox-reindexing");
    private final ReIndexerPerformer reIndexerPerformer;
    private final MailboxId mailboxId;
    private final ReprocessingContext reprocessingContext;
    private final ReIndexer.RunningOptions runningOptions;

    @Inject
    public SingleMailboxReindexingTask(ReIndexerPerformer reIndexerPerformer, MailboxId mailboxId, ReIndexer.RunningOptions runningOptions) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.mailboxId = mailboxId;
        this.reprocessingContext = new ReprocessingContext();
        this.runningOptions = runningOptions;
    }

    public Task.Result run() {
        try {
            return (Task.Result)this.reIndexerPerformer.reIndexSingleMailbox(this.mailboxId, this.reprocessingContext, this.runningOptions).block();
        }
        catch (Exception e) {
            return Task.Result.PARTIAL;
        }
    }

    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    public TaskType type() {
        return TYPE;
    }

    public ReIndexer.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.mailboxId, this.reprocessingContext.successfullyReprocessedMailCount(), this.reprocessingContext.failedReprocessingMailCount(), this.reprocessingContext.failures(), Clock.systemUTC().instant(), this.runningOptions));
    }

    public static class AdditionalInformation
    extends ReprocessingContextInformation {
        private final MailboxId mailboxId;

        @VisibleForTesting
        public AdditionalInformation(MailboxId mailboxId, int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp, ReIndexer.RunningOptions runningOptions) {
            super(successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp, runningOptions);
            this.mailboxId = mailboxId;
        }

        public String getMailboxId() {
            return this.mailboxId.serialize();
        }
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer, MailboxId.Factory mailboxIdFactory) {
            this.reIndexerPerformer = reIndexerPerformer;
            this.mailboxIdFactory = mailboxIdFactory;
        }

        public SingleMailboxReindexingTask create(SingleMailboxReindexingTaskDTO dto) {
            MailboxId mailboxId = this.mailboxIdFactory.fromString(dto.getMailboxId());
            return new SingleMailboxReindexingTask(this.reIndexerPerformer, mailboxId, dto.getRunningOptions().map(RunningOptionsDTO::toDomainObject).orElse(ReIndexer.RunningOptions.DEFAULT));
        }
    }
}

