/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;
import org.apache.mailbox.tools.indexer.UserReindexingTaskDTO;
import reactor.core.publisher.Mono;

public class UserReindexingTask
implements Task {
    public static final TaskType USER_RE_INDEXING = TaskType.of((String)"user-reindexing");
    private final ReIndexerPerformer reIndexerPerformer;
    private final Username username;
    private final ReprocessingContext reprocessingContext;
    private final ReIndexer.RunningOptions runningOptions;

    @Inject
    public UserReindexingTask(ReIndexerPerformer reIndexerPerformer, Username username, ReIndexer.RunningOptions runningOptions) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.username = username;
        this.reprocessingContext = new ReprocessingContext();
        this.runningOptions = runningOptions;
    }

    public Task.Result run() {
        return (Task.Result)this.reIndexerPerformer.reIndexUserMailboxes(this.username, this.reprocessingContext, this.runningOptions).onErrorResume(e -> Mono.just((Object)Task.Result.PARTIAL)).block();
    }

    public Username getUsername() {
        return this.username;
    }

    public TaskType type() {
        return USER_RE_INDEXING;
    }

    public ReIndexer.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.username, this.reprocessingContext.successfullyReprocessedMailCount(), this.reprocessingContext.failedReprocessingMailCount(), this.reprocessingContext.failures(), Clock.systemUTC().instant(), this.runningOptions));
    }

    public static class AdditionalInformation
    extends ReprocessingContextInformation {
        private final Username username;

        @VisibleForTesting
        public AdditionalInformation(Username username, int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp, ReIndexer.RunningOptions runningOptions) {
            super(successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp, runningOptions);
            this.username = username;
        }

        public String getUsername() {
            return this.username.asString();
        }
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer) {
            this.reIndexerPerformer = reIndexerPerformer;
        }

        public UserReindexingTask create(UserReindexingTaskDTO dto) {
            Username username = Username.of((String)dto.getUsername());
            return new UserReindexingTask(this.reIndexerPerformer, username, dto.getRunningOptions().map(RunningOptionsDTO::toDomainObject).orElse(ReIndexer.RunningOptions.DEFAULT));
        }
    }
}

