/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManagerWorker;
import org.apache.james.task.TaskWithId;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class SerialTaskManagerWorker
implements TaskManagerWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialTaskManagerWorker.class);
    public static final boolean MAY_INTERRUPT_IF_RUNNING = true;
    private final Scheduler taskExecutor;
    private final TaskManagerWorker.Listener listener;
    private final AtomicReference<Tuple2<TaskId, CompletableFuture>> runningTask;
    private final Set<TaskId> cancelledTasks;
    private final Duration pollingInterval;

    public SerialTaskManagerWorker(TaskManagerWorker.Listener listener, Duration pollingInterval) {
        this.pollingInterval = pollingInterval;
        this.taskExecutor = Schedulers.fromExecutor((Executor)Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.withName((String)"task executor")));
        this.listener = listener;
        this.cancelledTasks = Sets.newConcurrentHashSet();
        this.runningTask = new AtomicReference();
    }

    @Override
    public Mono<Task.Result> executeTask(TaskWithId taskWithId) {
        if (!this.cancelledTasks.remove(taskWithId.getId())) {
            Mono taskMono = Mono.fromCallable(() -> this.runWithMdc(taskWithId, this.listener)).subscribeOn(this.taskExecutor);
            CompletableFuture future = taskMono.toFuture();
            this.runningTask.set((Tuple2<TaskId, CompletableFuture>)Tuples.of((Object)taskWithId.getId(), (Object)future));
            return Mono.using(() -> this.pollAdditionalInformation(taskWithId).subscribe(), ignored -> Mono.fromFuture((CompletableFuture)future).onErrorResume(exception -> Mono.from(this.handleExecutionError(taskWithId, this.listener, (Throwable)exception)).thenReturn((Object)Task.Result.PARTIAL)), Disposable::dispose);
        }
        return Mono.from(this.listener.cancelled(taskWithId.getId(), taskWithId.getTask().details())).then(Mono.empty());
    }

    private Publisher<Void> handleExecutionError(TaskWithId taskWithId, TaskManagerWorker.Listener listener, Throwable exception) {
        if (exception instanceof CancellationException) {
            return listener.cancelled(taskWithId.getId(), taskWithId.getTask().details());
        }
        return listener.failed(taskWithId.getId(), taskWithId.getTask().details(), exception);
    }

    private Flux<TaskExecutionDetails.AdditionalInformation> pollAdditionalInformation(TaskWithId taskWithId) {
        return Mono.fromCallable(() -> taskWithId.getTask().details()).delayElement(this.pollingInterval, Schedulers.elastic()).repeat().handle(ReactorUtils.publishIfPresent()).flatMap(information -> Mono.from(this.listener.updated(taskWithId.getId(), (TaskExecutionDetails.AdditionalInformation)information)).thenReturn(information), 16);
    }

    private Task.Result runWithMdc(TaskWithId taskWithId, TaskManagerWorker.Listener listener) {
        return (Task.Result)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("taskId", taskWithId.getId().asString()).addToContext("taskType", taskWithId.getTask().type().asString()).addToContext("taskDetails", taskWithId.getTask().details().toString()), () -> (Task.Result)this.run(taskWithId, listener).block());
    }

    private Mono<Task.Result> run(TaskWithId taskWithId, TaskManagerWorker.Listener listener) {
        return Mono.from(listener.started(taskWithId.getId())).then(this.runTask(taskWithId, listener)).onErrorResume(this::isCausedByInterruptedException, e -> this.cancelled(taskWithId, listener)).onErrorResume(Exception.class, e -> {
            LOGGER.error("Error while running task {}", (Object)taskWithId.getId(), e);
            return Mono.from(listener.failed(taskWithId.getId(), taskWithId.getTask().details(), (Throwable)e)).thenReturn((Object)Task.Result.PARTIAL);
        });
    }

    private boolean isCausedByInterruptedException(Throwable e) {
        if (e instanceof InterruptedException) {
            return true;
        }
        return Stream.iterate(e, t -> t.getCause() != null, Throwable::getCause).anyMatch(t -> t instanceof InterruptedException);
    }

    private Mono<Task.Result> cancelled(TaskWithId taskWithId, TaskManagerWorker.Listener listener) {
        TaskId id = taskWithId.getId();
        Optional details = taskWithId.getTask().details();
        return Mono.from(listener.cancelled(id, details)).thenReturn((Object)Task.Result.PARTIAL);
    }

    private Mono<Task.Result> runTask(TaskWithId taskWithId, TaskManagerWorker.Listener listener) {
        return Mono.fromCallable(() -> taskWithId.getTask().run()).doOnNext(result -> result.onComplete(new Task.CompletionOperation[]{any -> Mono.from(listener.completed(taskWithId.getId(), (Task.Result)result, taskWithId.getTask().details())).block()}).onFailure(new Task.Operation[]{() -> {
            LOGGER.error("Task was partially performed. Check logs for more details. Taskid : " + String.valueOf(taskWithId.getId()));
            Mono.from(listener.failed(taskWithId.getId(), taskWithId.getTask().details())).block();
        }}));
    }

    @Override
    public void cancelTask(TaskId taskId) {
        this.cancelledTasks.add(taskId);
        Optional.ofNullable(this.runningTask.get()).filter(task -> ((TaskId)task.getT1()).equals((Object)taskId)).ifPresent(task -> ((CompletableFuture)task.getT2()).cancel(true));
    }

    @Override
    public Publisher<Void> fail(TaskId taskId, Optional<TaskExecutionDetails.AdditionalInformation> additionalInformation, String errorMessage, Throwable reason) {
        return this.listener.failed(taskId, additionalInformation, errorMessage, reason);
    }

    @Override
    public void close() {
        this.taskExecutor.dispose();
    }
}

