/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.History$;
import org.apache.james.eventsourcing.eventstore.cassandra.CassandraEventStoreTable$;
import org.apache.james.eventsourcing.eventstore.cassandra.JsonEventSerializer;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001B\f\u0019\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tu\u0001\u0011\t\u0011)A\u0005]!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u000bA\u0003A\u0011A)\t\u000f}\u0003!\u0019!C\u0005A\"1q\r\u0001Q\u0001\n\u0005Dq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004n\u0001\u0001\u0006IA\u001b\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019\u0019\b\u0001)A\u0005a\"9A\u000f\u0001b\u0001\n\u0013y\u0007BB;\u0001A\u0003%\u0001\u000fC\u0003w\u0001\u0011%q\u000fC\u0003z\u0001\u0011%!\u0010\u0003\u0004}\u0001\u0011\u0005\u0001$ \u0005\b\u0003w\u0001A\u0011BA\u001f\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013B\u0001\"!\u0016\u0001\t\u0003A\u0012q\u000b\u0005\b\u0003[\u0002A\u0011BA8\u00055)e/\u001a8u'R|'/\u001a#b_*\u0011\u0011DG\u0001\nG\u0006\u001c8/\u00198ee\u0006T!a\u0007\u000f\u0002\u0015\u00154XM\u001c;ti>\u0014XM\u0003\u0002\u001e=\u0005iQM^3oiN|WO]2j]\u001eT!a\b\u0011\u0002\u000b)\fW.Z:\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VMZ\u0001\bg\u0016\u001c8/[8o+\u0005q\u0003CA\u00189\u001b\u0005\u0001$BA\u00193\u0003\u0011\u0019wN]3\u000b\u0005M\"\u0014A\u00023sSZ,'O\u0003\u00026m\u0005AA-\u0019;bgR\f\u0007PC\u00018\u0003\r\u0019w.\\\u0005\u0003sA\u0012qaU3tg&|g.\u0001\u0005tKN\u001c\u0018n\u001c8!\u0003MQ7o\u001c8Fm\u0016tGoU3sS\u0006d\u0017N_3s+\u0005i\u0004C\u0001 @\u001b\u0005A\u0012B\u0001!\u0019\u0005MQ5o\u001c8Fm\u0016tGoU3sS\u0006d\u0017N_3s\u0003QQ7o\u001c8Fm\u0016tGoU3sS\u0006d\u0017N_3sA\u0005Q2m\u001c8tSN$XM\\2jKN\u001cuN\u001c4jOV\u0014\u0018\r^5p]V\tA\t\u0005\u0002F\u001b6\taI\u0003\u0002H\u0011\u0006i1m\u001c8gS\u001e,(/\u0019;j_:T!!\u0013&\u0002\t%t\u0017\u000e\u001e\u0006\u00033-S!\u0001\u0014\u0010\u0002\u0011\t\f7m[3oINL!A\u0014$\u0003G\r\u000b7o]1oIJ\f7i\u001c8tSN$XM\\2jKN\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006Y2m\u001c8tSN$XM\\2jKN\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0002\na\u0001P5oSRtD\u0003\u0002*T)V\u0003\"A\u0010\u0001\t\u000b1:\u0001\u0019\u0001\u0018\t\u000bm:\u0001\u0019A\u001f\t\u000b\t;\u0001\u0019\u0001#)\u0005\u001d9\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0019IgN[3di*\tA,A\u0003kCZ\f\u00070\u0003\u0002_3\n1\u0011J\u001c6fGR\facY1tg\u0006tGM]1Bgft7-\u0012=fGV$xN]\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011AMS\u0001\u0006kRLGn]\u0005\u0003M\u000e\u0014acQ1tg\u0006tGM]1Bgft7-\u0012=fGV$xN]\u0001\u0018G\u0006\u001c8/\u00198ee\u0006\f5/\u001f8d\u000bb,7-\u001e;pe\u0002\n\u0001cY8og&\u001cH/\u001a8ds2+g/\u001a7\u0016\u0003)\u0004\"aL6\n\u00051\u0004$\u0001E\"p]NL7\u000f^3oGfdUM^3m\u0003E\u0019wN\\:jgR,gnY=MKZ,G\u000eI\u0001\u0007S:\u001cXM\u001d;\u0016\u0003A\u0004\"aL9\n\u0005I\u0004$!\u0005)sKB\f'/\u001a3Ti\u0006$X-\\3oi\u00069\u0011N\\:feR\u0004\u0013AB:fY\u0016\u001cG/A\u0004tK2,7\r\u001e\u0011\u0002\u001bA\u0014X\r]1sK&s7/\u001a:u)\t\u0001\b\u0010C\u0003-!\u0001\u0007a&A\u0007qe\u0016\u0004\u0018M]3TK2,7\r\u001e\u000b\u0003anDQ\u0001L\tA\u00029\n\u0011\"\u00199qK:$\u0017\t\u001c7\u0015\u0007y\f9\u0002E\u0003\u0000\u0003\u001b\t\t\"\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003%\u0001XO\u00197jg\",'OC\u0002*\u0003\u000fQ1!MA\u0005\u0015\t\tY!A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005=\u0011\u0011\u0001\u0002\u0006'6{gn\u001c\t\u0004O\u0005M\u0011bAA\u000bQ\t9!i\\8mK\u0006t\u0007bBA\r%\u0001\u0007\u00111D\u0001\u0007KZ,g\u000e^:\u0011\r\u0005u\u0011QFA\u001a\u001d\u0011\ty\"!\u000b\u000f\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n%\u0003\u0019a$o\\8u}%\t\u0011&C\u0002\u0002,!\nq\u0001]1dW\u0006<W-\u0003\u0003\u00020\u0005E\"\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005-\u0002\u0006\u0005\u0003\u00026\u0005]R\"\u0001\u000f\n\u0007\u0005eBDA\u0003Fm\u0016tG/A\u0006baB,g\u000eZ)vKJLH\u0003BA \u0003\u000b\u00022aLA!\u0013\r\t\u0019\u0005\r\u0002\n'R\fG/Z7f]RDq!!\u0007\u0014\u0001\u0004\tY\"A\u0006j]N,'\u000f^#wK:$H\u0003BA&\u0003#\u00022aLA'\u0013\r\ty\u0005\r\u0002\u000f\u0005>,h\u000eZ*uCR,W.\u001a8u\u0011\u001d\t\u0019\u0006\u0006a\u0001\u0003g\tQ!\u001a<f]R\fAcZ3u\u000bZ,g\u000e^:PM\u0006;wM]3hCR,G\u0003BA-\u0003G\u0002Ra`A\u0007\u00037\u0002B!!\u0018\u0002`5\t!$C\u0002\u0002bi\u0011q\u0001S5ti>\u0014\u0018\u0010C\u0004\u0002fU\u0001\r!a\u001a\u0002\u0017\u0005<wM]3hCR,\u0017\n\u001a\t\u0005\u0003k\tI'C\u0002\u0002lq\u00111\"Q4he\u0016<\u0017\r^3JI\u00069Ao\\#wK:$H\u0003BA\u001a\u0003cBq!a\u001d\u0017\u0001\u0004\t)(A\u0002s_^\u00042aLA<\u0013\r\tI\b\r\u0002\u0004%><\b")
public class EventStoreDao {
    private final Session session;
    private final JsonEventSerializer jsonEventSerializer;
    private final CassandraConsistenciesConfiguration consistenciesConfiguration;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final ConsistencyLevel consistencyLevel;
    private final PreparedStatement insert;
    private final PreparedStatement select;

    public Session session() {
        return this.session;
    }

    public JsonEventSerializer jsonEventSerializer() {
        return this.jsonEventSerializer;
    }

    public CassandraConsistenciesConfiguration consistenciesConfiguration() {
        return this.consistenciesConfiguration;
    }

    private CassandraAsyncExecutor cassandraAsyncExecutor() {
        return this.cassandraAsyncExecutor;
    }

    private ConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    private PreparedStatement insert() {
        return this.insert;
    }

    private PreparedStatement select() {
        return this.select;
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).value(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), (Object)QueryBuilder.bindMarker((String)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID())).value(CassandraEventStoreTable$.MODULE$.EVENT_ID(), (Object)QueryBuilder.bindMarker((String)CassandraEventStoreTable$.MODULE$.EVENT_ID())).value(CassandraEventStoreTable$.MODULE$.EVENT(), (Object)QueryBuilder.bindMarker((String)CassandraEventStoreTable$.MODULE$.EVENT())).ifNotExists());
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from(CassandraEventStoreTable$.MODULE$.EVENTS_TABLE()).where(QueryBuilder.eq((String)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), (Object)QueryBuilder.bindMarker((String)CassandraEventStoreTable$.MODULE$.AGGREGATE_ID()))));
    }

    public SMono<Object> appendAll(Iterable<Event> events) {
        return SMono$.MODULE$.apply((Publisher)this.cassandraAsyncExecutor().executeReturnApplied(this.appendQuery(events)).map(x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1)));
    }

    /*
     * WARNING - void declaration
     */
    private Statement appendQuery(Iterable<Event> events) {
        BoundStatement boundStatement;
        if (events.size() == 1) {
            boundStatement = this.insertEvent((Event)events.head());
        } else {
            void var2_2;
            BatchStatement batch = new BatchStatement();
            events.foreach((Function1 & Serializable)event -> batch.add((Statement)this.insertEvent((Event)event)));
            boundStatement = var2_2;
        }
        return boundStatement;
    }

    private BoundStatement insertEvent(Event event) {
        return this.insert().bind().setString(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), event.getAggregateId().asAggregateKey()).setInt(CassandraEventStoreTable$.MODULE$.EVENT_ID(), event.eventId().serialize()).setString(CassandraEventStoreTable$.MODULE$.EVENT(), this.jsonEventSerializer().serialize(event));
    }

    public SMono<History> getEventsOfAggregate(AggregateId aggregateId) {
        Statement preparedStatement = this.select().bind().setString(CassandraEventStoreTable$.MODULE$.AGGREGATE_ID(), aggregateId.asAggregateKey()).setConsistencyLevel(this.consistencyLevel());
        SFlux rows = SFlux$.MODULE$.apply((Publisher)this.cassandraAsyncExecutor().executeRows(preparedStatement));
        SFlux events = rows.map((Function1 & Serializable)row -> this.toEvent((Row)row));
        SMono listEvents = events.collectSeq().map((Function1 & Serializable)x$2 -> x$2.toList());
        return listEvents.map((Function1 & Serializable)x$3 -> History$.MODULE$.of(x$3));
    }

    private Event toEvent(Row row) {
        return this.jsonEventSerializer().deserialize(row.getString(CassandraEventStoreTable$.MODULE$.EVENT()));
    }

    @Inject
    public EventStoreDao(Session session, JsonEventSerializer jsonEventSerializer, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this.session = session;
        this.jsonEventSerializer = jsonEventSerializer;
        this.consistenciesConfiguration = consistenciesConfiguration;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.consistencyLevel = consistenciesConfiguration.getLightweightTransaction();
        this.insert = this.prepareInsert(session);
        this.select = this.prepareSelect(session);
    }
}

